/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.neoforge.datagen;

import biomesoplenty.init.ModBiomes;
import biomesoplenty.init.ModDamageTypes;
import biomesoplenty.init.ModJukeboxSongs;
import biomesoplenty.neoforge.datagen.provider.BOPDataMapProvider;
import biomesoplenty.neoforge.datagen.provider.BOPLootTableProvider;
import biomesoplenty.neoforge.datagen.provider.BOPRecipeProvider;
import biomesoplenty.util.worldgen.BOPFeatureUtils;
import biomesoplenty.util.worldgen.BOPPlacementUtils;
import biomesoplenty.worldgen.carver.BOPConfiguredCarvers;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Cloner;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.RegistriesDatapackGenerator;
import net.minecraft.resources.RegistryDataLoader;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="biomesoplenty")
public class DataGenerationHandler {
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.CONFIGURED_CARVER, BOPConfiguredCarvers::bootstrap).add(Registries.CONFIGURED_FEATURE, BOPFeatureUtils::bootstrap).add(Registries.PLACED_FEATURE, BOPPlacementUtils::bootstrap).add(Registries.BIOME, ModBiomes::bootstrapBiomes).add(Registries.DAMAGE_TYPE, ModDamageTypes::bootstrap).add(Registries.JUKEBOX_SONG, ModJukeboxSongs::bootstrap);

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        RegistriesDatapackGenerator datapackProvider = (RegistriesDatapackGenerator)generator.addProvider(event.includeServer(), (DataProvider)new RegistriesDatapackGenerator(output, (CompletableFuture)event.getLookupProvider().thenApply(r -> DataGenerationHandler.constructRegistries(r, BUILDER)), Set.of("biomesoplenty")));
        generator.addProvider(event.includeServer(), (DataProvider)new BOPRecipeProvider(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)BOPLootTableProvider.create(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new BOPDataMapProvider(output, lookupProvider));
    }

    private static HolderLookup.Provider constructRegistries(HolderLookup.Provider original, RegistrySetBuilder datapackEntriesBuilder) {
        Cloner.Factory clonerFactory = new Cloner.Factory();
        HashSet builderKeys = new HashSet(datapackEntriesBuilder.getEntryKeys());
        RegistryDataLoader.WORLDGEN_REGISTRIES.stream().forEach(data -> {
            if (!builderKeys.contains(data.key())) {
                datapackEntriesBuilder.add(data.key(), context -> {});
            }
            data.runWithArguments((arg_0, arg_1) -> ((Cloner.Factory)clonerFactory).addCodec(arg_0, arg_1));
        });
        return datapackEntriesBuilder.buildPatch((RegistryAccess)RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY), original, clonerFactory).patches();
    }
}

