/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TinyCactusBlock
extends BushBlock {
    public static final MapCodec<TinyCactusBlock> CODEC = TinyCactusBlock.simpleCodec(TinyCactusBlock::new);
    protected static final VoxelShape NORMAL = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);

    public TinyCactusBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<TinyCactusBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext selectionContext) {
        return NORMAL;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState groundState = worldIn.getBlockState(pos.below());
        return groundState.is(BlockTags.DIRT) || groundState.is(BlockTags.SAND);
    }

    public void entityInside(BlockState p_51148_, Level p_51149_, BlockPos p_51150_, Entity p_51151_) {
        if (p_51151_ instanceof Player) {
            Player playerEntity = (Player)p_51151_;
            playerEntity.hurt(p_51149_.damageSources().cactus(), 1.0f);
        }
    }
}

