/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber
public class TickHelper {
    private static final Map<Integer, List<Runnable>> tickTasks = new HashMap<Integer, List<Runnable>>();
    private static int tickTimerFsr = 0;

    public static void addTask(int tick, Runnable task) {
        if (!tickTasks.containsKey(tick)) {
            tickTasks.put(tick, new ArrayList());
        }
        tickTasks.get(tick).add(task);
    }

    public static void nextTick(Level level, Runnable task) {
        TickHelper.addTask(Objects.requireNonNull(level.getServer()).getTickCount() + 1, task);
    }

    public static void TickLater(Level level, int tickNumber, Runnable task) {
        TickHelper.addTask(Objects.requireNonNull(level.getServer()).getTickCount() + tickNumber, task);
    }

    @SubscribeEvent
    static void runTasks(LevelTickEvent.Pre event) {
        if (event.getLevel() instanceof ServerLevel && tickTimerFsr == 0 && tickTasks.containsKey(event.getLevel().getServer().getTickCount())) {
            tickTasks.get(event.getLevel().getServer().getTickCount()).forEach(Runnable::run);
            tickTasks.remove(event.getLevel().getServer().getTickCount());
            tickTimerFsr += 3;
        } else if (tickTimerFsr > 0) {
            --tickTimerFsr;
        }
    }
}

