/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.mixin.toughasnails;

import dev.ghen.thirst.content.purity.WaterPurity;
import dev.ghen.thirst.foundation.util.MathHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import toughasnails.api.block.TANBlocks;
import toughasnails.block.RainCollectorBlock;
import toughasnails.item.EmptyCanteenItem;

@Mixin(value={EmptyCanteenItem.class})
public abstract class MixinEmptyCanteenItem {
    @Shadow(remap=false)
    protected abstract ItemStack replaceCanteen(ItemStack var1, Player var2, ItemStack var3);

    @Shadow
    public abstract Item getPurifiedWaterCanteen();

    @Shadow
    public abstract Item getWaterCanteen();

    @Shadow
    public abstract Item getDirtyWaterCanteen();

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void use(Level world, Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        int waterLevel;
        ItemStack stack = player.getItemInHand(hand);
        Level level = player.level();
        BlockPos blockPos = MathHelper.getPlayerPOVHitResult(level, player, ClipContext.Fluid.ANY).getBlockPos();
        BlockState state = world.getBlockState(blockPos);
        if (!world.mayInteract(player, blockPos)) {
            cir.setReturnValue((Object)InteractionResultHolder.pass((Object)stack));
        }
        if (level.getFluidState(blockPos).is(FluidTags.WATER)) {
            SoundEvent sound = SoundEvents.BOTTLE_FILL;
            level.playSound(player, player.getX(), player.getY(), player.getZ(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
            level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, blockPos);
            int purity = WaterPurity.getBlockPurity(level, blockPos);
            ItemStack filledItem = purity == 3 ? this.getPurifiedWaterCanteen().getDefaultInstance() : (purity == 2 ? this.getWaterCanteen().getDefaultInstance() : this.getDirtyWaterCanteen().getDefaultInstance());
            ItemStack result = ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)filledItem);
            cir.setReturnValue((Object)InteractionResultHolder.sidedSuccess((Object)this.replaceCanteen(stack, player, result), (boolean)world.isClientSide()));
        } else if (state.getBlock() instanceof RainCollectorBlock && (waterLevel = ((Integer)state.getValue((Property)RainCollectorBlock.LEVEL)).intValue()) > 0 && !world.isClientSide()) {
            world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
            ((RainCollectorBlock)TANBlocks.RAIN_COLLECTOR).setWaterLevel(world, blockPos, state, waterLevel - 1);
            cir.setReturnValue((Object)InteractionResultHolder.success((Object)this.replaceCanteen(stack, player, this.getPurifiedWaterCanteen().getDefaultInstance())));
        }
    }
}

