/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.mixin;

import dev.ghen.thirst.content.purity.WaterPurity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CampfireBlockEntity.class})
public class MixinCampfireBlockEntity {
    @Inject(method={"particleTick"}, at={@At(value="HEAD")}, cancellable=true)
    private static void waterVapour(Level level, BlockPos pos, BlockState blockState, CampfireBlockEntity campfire, CallbackInfo ci) {
        int i;
        RandomSource random = level.getRandom();
        int l = ((Direction)blockState.getValue((Property)CampfireBlock.FACING)).get2DDataValue();
        boolean cancel = false;
        for (i = 0; i < campfire.getItems().size(); ++i) {
            ItemStack itemstack = (ItemStack)campfire.getItems().get(i);
            if (!WaterPurity.isWaterFilledContainer(itemstack)) continue;
            cancel = true;
            if (!(random.nextFloat() < 0.2f)) continue;
            Direction direction = Direction.from2DDataValue((int)Math.floorMod(i + l, 4));
            float f = 0.3125f;
            double d0 = (double)pos.getX() + 0.5 - (double)((float)direction.getStepX() * 0.3125f) + (double)((float)direction.getClockWise().getStepX() * 0.3125f);
            double d1 = (double)pos.getY() + 0.6;
            double d2 = (double)pos.getZ() + 0.5 - (double)((float)direction.getStepZ() * 0.3125f) + (double)((float)direction.getClockWise().getStepZ() * 0.3125f);
            level.addParticle((ParticleOptions)ParticleTypes.EFFECT, d0, d1, d2, 0.0, 0.001, 0.0);
        }
        if (cancel) {
            if (random.nextFloat() < 0.11f) {
                for (i = 0; i < random.nextInt(2) + 2; ++i) {
                    CampfireBlock.makeParticles((Level)level, (BlockPos)pos, (boolean)((Boolean)blockState.getValue((Property)CampfireBlock.SIGNAL_FIRE)), (boolean)false);
                }
            }
            ci.cancel();
        }
    }
}

