/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.gui.appleskin;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ghen.thirst.Thirst;
import dev.ghen.thirst.api.ThirstHelper;
import dev.ghen.thirst.compat.supernatural.SupernaturalHelper;
import dev.ghen.thirst.content.thirst.PlayerThirst;
import dev.ghen.thirst.foundation.common.capability.IThirst;
import dev.ghen.thirst.foundation.common.capability.ModAttachment;
import dev.ghen.thirst.foundation.config.ClientConfig;
import dev.ghen.thirst.foundation.gui.ThirstBarRenderer;
import dev.ghen.thirst.foundation.gui.appleskin.ThirstValues;
import java.util.Random;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.NeoForge;
import squeek.appleskin.ModConfig;
import squeek.appleskin.client.HUDOverlayHandler;
import squeek.appleskin.util.IntPoint;

@OnlyIn(value=Dist.CLIENT)
public class HUDOverlayHandler {
    private static float unclampedFlashAlpha = 0.0f;
    private static float flashAlpha = 0.0f;
    private static byte alphaDir = 1;
    protected static int foodIconsOffset;
    public static final Vector<IntPoint> foodBarOffsets;
    private static final Random random;
    private static final ResourceLocation modIcons;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new HUDOverlayHandler());
    }

    public static boolean shouldDrawSurvivalElements(Minecraft minecraft) {
        return minecraft.gameMode.canHurtPlayer() && minecraft.getCameraEntity() instanceof Player;
    }

    public static void renderExhaustion(Gui gui, GuiGraphics mStack) {
        int offset = 10;
        if (ModList.get().isLoaded("supernatural") && SupernaturalHelper.hasVampirismCheck((Player)Minecraft.getInstance().player)) {
            offset = 0;
        }
        foodIconsOffset = gui.rightHeight + offset;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        assert (player != null);
        int right = mc.getWindow().getGuiScaledWidth() / 2 + 91 + (Integer)ClientConfig.THIRST_BAR_X_OFFSET.get();
        int top = mc.getWindow().getGuiScaledHeight() - foodIconsOffset + (Integer)ClientConfig.THIRST_BAR_Y_OFFSET.get();
        float exhaustion = ((PlayerThirst)player.getData(ModAttachment.PLAYER_THIRST)).getExhaustion();
        HUDOverlayHandler.drawExhaustionOverlay(exhaustion, mStack, right, top);
    }

    public static void renderThirstOverlay(GuiGraphics guiGraphics) {
        boolean shouldRenderHeldItemValues;
        if (!HUDOverlayHandler.shouldRenderAnyOverlays()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        assert (player != null);
        IThirst thirstData = (IThirst)player.getData(ModAttachment.PLAYER_THIRST);
        int right = mc.getWindow().getGuiScaledWidth() / 2 + 91 + (Integer)ClientConfig.THIRST_BAR_X_OFFSET.get();
        int top = mc.getWindow().getGuiScaledHeight() - foodIconsOffset + (Integer)ClientConfig.THIRST_BAR_Y_OFFSET.get();
        HUDOverlayHandler.generateHungerBarOffsets(top, right, mc.gui.getGuiTicks(), (Player)player);
        if (((Boolean)ModConfig.SHOW_SATURATION_OVERLAY.get()).booleanValue()) {
            HUDOverlayHandler.drawSaturationOverlay(0.0f, thirstData.getQuenched(), guiGraphics, right, top, 1.0f);
        }
        ItemStack heldItem = player.getMainHandItem();
        if (((Boolean)ModConfig.SHOW_FOOD_VALUES_OVERLAY_WHEN_OFFHAND.get()).booleanValue() && !ThirstHelper.itemRestoresThirst(heldItem)) {
            heldItem = player.getOffhandItem();
        }
        boolean bl = shouldRenderHeldItemValues = !heldItem.isEmpty() && ThirstHelper.itemRestoresThirst(heldItem);
        if (!shouldRenderHeldItemValues) {
            HUDOverlayHandler.resetFlash();
            return;
        }
        ThirstValues thirstValues = new ThirstValues(ThirstHelper.getThirst(heldItem), ThirstHelper.getQuenched(heldItem));
        int drinkThirst = thirstValues.thirst;
        if (thirstData.getThirst() < 20) {
            HUDOverlayHandler.drawHungerOverlay(drinkThirst, thirstData.getThirst(), guiGraphics, right, top, flashAlpha);
        }
        if (!ThirstHelper.isFood(heldItem) || player.getFoodData().getFoodLevel() < 20) {
            HUDOverlayHandler.drawSaturationOverlay(thirstValues.quenchedModifier, thirstData.getQuenched(), guiGraphics, right, top, flashAlpha);
        }
    }

    public static void drawSaturationOverlay(float saturationGained, float saturationLevel, GuiGraphics guiGraphics, int right, int top, float alpha) {
        if (saturationLevel + saturationGained < 0.0f) {
            return;
        }
        HUDOverlayHandler.enableAlpha(alpha);
        float modifiedSaturation = Math.max(0.0f, Math.min(saturationLevel + saturationGained, 20.0f));
        ResourceLocation icons = modIcons;
        if (ModList.get().isLoaded("supernatural")) {
            icons = SupernaturalHelper.getVampireAppleskinIcons(modIcons, (Player)Minecraft.getInstance().player);
        }
        int startSaturationBar = 0;
        int endSaturationBar = (int)Math.ceil(modifiedSaturation / 2.0f);
        if (saturationGained != 0.0f) {
            startSaturationBar = (int)Math.max(saturationLevel / 2.0f, 0.0f);
        }
        int iconSize = 9;
        for (int i = startSaturationBar; i < endSaturationBar; ++i) {
            IntPoint offset = foodBarOffsets.get(i);
            if (offset == null) continue;
            int x = right + offset.x;
            int y = top + offset.y;
            int v = 0;
            int u = 0;
            float effectiveSaturationOfBar = modifiedSaturation / 2.0f - (float)i;
            if (effectiveSaturationOfBar >= 1.0f) {
                u = 3 * iconSize;
            } else if ((double)effectiveSaturationOfBar > 0.5) {
                u = 2 * iconSize;
            } else if ((double)effectiveSaturationOfBar > 0.25) {
                u = iconSize;
            }
            guiGraphics.blit(icons, x, y, u, v, iconSize, iconSize);
        }
        HUDOverlayHandler.disableAlpha();
    }

    public static void drawHungerOverlay(int hungerRestored, int foodLevel, GuiGraphics guiGraphics, int right, int top, float alpha) {
        if (hungerRestored <= 0) {
            return;
        }
        HUDOverlayHandler.enableAlpha(alpha);
        int modifiedFood = Math.max(0, Math.min(20, foodLevel + hungerRestored));
        int startFoodBars = Math.max(0, foodLevel / 2);
        int endFoodBars = (int)Math.ceil((float)modifiedFood / 2.0f);
        int iconStartOffset = 5;
        int iconSize = 9;
        for (int i = startFoodBars; i < endFoodBars; ++i) {
            IntPoint offset = foodBarOffsets.get(i);
            if (offset == null) continue;
            int x = right + offset.x;
            int y = top + offset.y;
            int v = 3 * iconSize;
            int u = iconStartOffset + 4 * iconSize;
            if (i * 2 + 1 == modifiedFood) {
                u -= iconSize - 1;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            ResourceLocation icons = ThirstBarRenderer.THIRST_ICONS;
            if (ModList.get().isLoaded("supernatural")) {
                icons = SupernaturalHelper.getVampireIcons(icons, (Player)Minecraft.getInstance().player);
            }
            guiGraphics.blit(icons, x, y, (float)u, (float)v, iconSize, iconSize, 25, 9);
        }
        HUDOverlayHandler.disableAlpha();
    }

    public static void drawExhaustionOverlay(float exhaustion, GuiGraphics guiGraphics, int right, int top) {
        ResourceLocation icons = modIcons;
        if (ModList.get().isLoaded("supernatural")) {
            icons = SupernaturalHelper.getVampireAppleskinIcons(modIcons, (Player)Minecraft.getInstance().player);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)icons);
        float maxExhaustion = 4.0f;
        float ratio = Math.min(1.0f, Math.max(0.0f, exhaustion / maxExhaustion));
        int width = (int)(ratio * 81.0f);
        int height = 9;
        HUDOverlayHandler.enableAlpha(0.75f);
        guiGraphics.blit(icons, right - width, top, 81 - width, 18, width, height);
        HUDOverlayHandler.disableAlpha();
    }

    public static void enableAlpha(float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.blendFunc((int)770, (int)771);
    }

    public static void disableAlpha() {
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Pre event) {
        if ((unclampedFlashAlpha += (float)alphaDir * 0.125f) >= 1.5f) {
            alphaDir = (byte)-1;
        } else if (unclampedFlashAlpha <= -0.5f) {
            alphaDir = 1;
        }
        flashAlpha = Math.max(0.0f, Math.min(1.0f, unclampedFlashAlpha)) * 0.65f;
    }

    public static void resetFlash() {
        flashAlpha = 0.0f;
        unclampedFlashAlpha = 0.0f;
        alphaDir = 1;
    }

    private static boolean shouldRenderAnyOverlays() {
        return true;
    }

    private static void generateHungerBarOffsets(int top, int right, int ticks, Player player) {
        boolean shouldAnimatedFood;
        int preferFoodBars = 10;
        IThirst thirstData = (IThirst)player.getData(ModAttachment.PLAYER_THIRST);
        float quenched = thirstData.getQuenched();
        int thirst = thirstData.getThirst();
        boolean bl = shouldAnimatedFood = quenched <= 0.0f && ticks % (thirst * 3 + 1) == 0;
        if (foodBarOffsets.size() != 10) {
            foodBarOffsets.setSize(10);
        }
        for (int i = 0; i < 10; ++i) {
            IntPoint point;
            int x = right - i * 8 - 9;
            int y = top;
            if (shouldAnimatedFood) {
                y += random.nextInt(3) - 1;
            }
            if ((point = foodBarOffsets.get(i)) == null) {
                point = new IntPoint();
                foodBarOffsets.set(i, point);
            }
            point.x = x - right;
            point.y = y - top;
        }
    }

    static {
        foodBarOffsets = new Vector();
        random = new Random();
        modIcons = Thirst.asResource("textures/gui/appleskin_icons.png");
    }

    public static class SaturationOverlay
    extends HUDOverlayHandler.Overlay {
        public static final ResourceLocation ID = Thirst.asResource("saturation_overlay");

        public void render(Minecraft minecraft, Player player, GuiGraphics guiGraphics, int left, int right, int top, int guiTicks) {
            Minecraft mc = Minecraft.getInstance();
            boolean isMounted = mc.player.getVehicle() instanceof LivingEntity;
            boolean isAlive = mc.player.isAlive();
            if (isAlive && !isMounted && !mc.options.hideGui && HUDOverlayHandler.shouldDrawSurvivalElements(mc) && !ThirstBarRenderer.cancelRender.booleanValue()) {
                HUDOverlayHandler.renderThirstOverlay(guiGraphics);
            }
        }
    }

    public static class ExhaustionOverlay
    extends HUDOverlayHandler.Overlay {
        public static final ResourceLocation ID = Thirst.asResource("exhaustion_overlay");

        public void render(Minecraft minecraft, Player player, GuiGraphics guiGraphics, int left, int right, int top, int guiTicks) {
            Minecraft mc = Minecraft.getInstance();
            boolean isMounted = mc.player.getVehicle() instanceof LivingEntity;
            boolean isAlive = mc.player.isAlive();
            if (isAlive && !isMounted && !mc.options.hideGui && HUDOverlayHandler.shouldDrawSurvivalElements(mc) && !ThirstBarRenderer.cancelRender.booleanValue() && ((Boolean)ModConfig.SHOW_FOOD_EXHAUSTION_UNDERLAY.get()).booleanValue()) {
                HUDOverlayHandler.renderExhaustion(mc.gui, guiGraphics);
            }
        }
    }
}

