/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.common.item;

import dev.ghen.thirst.content.thirst.PlayerThirst;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class DrinkableItem
extends Item {
    private Item container;

    public DrinkableItem() {
        super(new Item.Properties().stacksTo(64));
    }

    public DrinkableItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public DrinkableItem setContainer(Item item) {
        this.container = item;
        return this;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack item, @NotNull Level level, @NotNull LivingEntity entity) {
        Player player;
        Player player2 = player = entity instanceof Player ? (Player)entity : null;
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, item);
        }
        if (player != null) {
            PlayerThirst.drink(item, player);
        }
        if (player != null) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            if (!player.getAbilities().instabuild) {
                item.shrink(1);
            }
        }
        if (player == null || !player.getAbilities().instabuild) {
            if (item.isEmpty()) {
                return new ItemStack((ItemLike)this.container);
            }
            if (player != null) {
                ItemStack container = new ItemStack((ItemLike)this.container);
                if (!player.getInventory().add(container)) {
                    player.drop(container, false);
                }
            }
        }
        level.gameEvent((Entity)entity, (Holder)GameEvent.ITEM_INTERACT_FINISH, entity.getEyePosition());
        return item;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity user) {
        return 32;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack p_42997_) {
        return UseAnim.DRINK;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level p_42993_, @NotNull Player p_42994_, @NotNull InteractionHand p_42995_) {
        return ItemUtils.startUsingInstantly((Level)p_42993_, (Player)p_42994_, (InteractionHand)p_42995_);
    }
}

