/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.content.thirst;

import de.teamlapen.vampirism.util.Helper;
import dev.ghen.thirst.api.ThirstHelper;
import dev.ghen.thirst.foundation.common.capability.IThirst;
import dev.ghen.thirst.foundation.common.capability.ModAttachment;
import dev.ghen.thirst.foundation.common.damagesource.ModDamageSource;
import dev.ghen.thirst.foundation.config.CommonConfig;
import dev.ghen.thirst.foundation.network.message.PlayerThirstSyncMessage;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public class PlayerThirst
implements IThirst,
INBTSerializable<CompoundTag> {
    public static boolean checkTombstoneEffects = false;
    public static boolean checkFDEffects = false;
    public static boolean checkLetsDoBakeryEffects = false;
    public static boolean checkLetsDoBreweryEffects = false;
    public static boolean checkVampirismEffects = false;
    int thirst = 20;
    int quenched = 5;
    float exhaustion = 0.0f;
    int damageTimer = 0;
    int syncTimer = 0;
    float prevTickExhaustion = 0.0f;
    boolean justHealed = false;
    boolean shouldTickThirst = true;
    boolean exhaustionRecalculate = false;
    boolean init = true;

    @Override
    public int getThirst() {
        return this.thirst;
    }

    @Override
    public void setThirst(int value) {
        this.thirst = value;
    }

    @Override
    public int getQuenched() {
        return this.quenched;
    }

    @Override
    public void setQuenched(int value) {
        this.quenched = value;
    }

    @Override
    public float getExhaustion() {
        return this.exhaustion;
    }

    @Override
    public void setExhaustion(float value) {
        this.exhaustion = value;
    }

    @Override
    public void setShouldTickThirst(boolean value) {
        this.shouldTickThirst = value;
    }

    @Override
    public boolean getShouldTickThirst() {
        return this.shouldTickThirst;
    }

    public static void drink(ItemStack item, Player player) {
        if (ThirstHelper.itemRestoresThirst(item) && ThirstHelper.playerRestoresThirst(item, player)) {
            ((PlayerThirst)player.getData(ModAttachment.PLAYER_THIRST)).drink(ThirstHelper.getThirst(item), ThirstHelper.getQuenched(item));
        }
    }

    @Override
    public void drink(int thirst, int quenched) {
        int extra_quenched = Math.max(this.thirst + thirst - 20, 0);
        if (!((Boolean)CommonConfig.EXTRA_HYDRATION_CONVERT_TO_QUENCHED.get()).booleanValue()) {
            extra_quenched = 0;
        }
        this.thirst = Math.min(this.thirst + thirst, 20);
        this.quenched = Math.min(this.quenched + quenched + extra_quenched, this.thirst);
    }

    @Override
    public void tick(Player player) {
        Difficulty difficulty = player.level().getDifficulty();
        if (player.getAbilities().invulnerable) {
            return;
        }
        if (!this.shouldTickThirst) {
            if (this.init) {
                this.init = false;
                this.updateThirstData(player);
            }
            return;
        }
        if (checkTombstoneEffects && player.getActiveEffects().stream().anyMatch(e -> e.getDescriptionId().contains("ghostly_shape"))) {
            return;
        }
        if (checkVampirismEffects && Helper.isVampire((Player)player)) {
            return;
        }
        AtomicBoolean isNourished = new AtomicBoolean(false);
        AtomicBoolean isStuffed = new AtomicBoolean(false);
        AtomicBoolean isSaturated = new AtomicBoolean(false);
        player.getActiveEffects().stream().anyMatch(mobEffectInstance -> {
            if (checkFDEffects && mobEffectInstance.getDescriptionId().contains("nourishment")) {
                isNourished.set(true);
            }
            if (checkLetsDoBakeryEffects && mobEffectInstance.getDescriptionId().contains("stuffed")) {
                isStuffed.set(true);
            }
            if (checkLetsDoBreweryEffects && mobEffectInstance.getDescriptionId().contains("saturated")) {
                isSaturated.set(true);
            }
            if (((Boolean)CommonConfig.DEPLETES_WHEN_NAUSED.get()).booleanValue() && mobEffectInstance.is(MobEffects.CONFUSION)) {
                this.addExhaustion(player, 0.06f);
            }
            return true;
        });
        boolean isHunger = player.hasEffect(MobEffects.HUNGER);
        boolean isSitting = player.isPassenger();
        if (isHunger) {
            this.exhaustion -= 0.005f * (float)(player.getEffect(MobEffects.HUNGER).getAmplifier() + 1) * ThirstHelper.getExhaustionBiomeModifier(player) * ThirstHelper.getExhaustionFireProtModifier(player) * ThirstHelper.getExhaustionFireResistanceModifier(player);
        }
        if (!(isSitting || isNourished.get() || isStuffed.get() || isSaturated.get())) {
            this.updateExhaustion(player);
        }
        if (this.exhaustion > 4.0f) {
            this.exhaustion -= 4.0f;
            if (this.quenched > 0) {
                --this.quenched;
            } else if (difficulty != Difficulty.PEACEFUL || ((Boolean)CommonConfig.THIRST_DEPLETION_IN_PEACEFUL.get()).booleanValue()) {
                this.thirst = Math.max(this.thirst - 1, 0);
            }
        }
        ++this.syncTimer;
        if (this.syncTimer > 10 && !player.level().isClientSide()) {
            float angle;
            if (difficulty == Difficulty.PEACEFUL && !((Boolean)CommonConfig.THIRST_DEPLETION_IN_PEACEFUL.get()).booleanValue()) {
                this.thirst = Math.min(this.thirst + 1, 20);
            }
            if ((angle = Mth.wrapDegrees((float)player.getXRot())) <= -80.0f && player.level().isRainingAt(player.blockPosition().above()) && ((Boolean)CommonConfig.CAN_DRINK_RAIN_WATETR.get()).booleanValue()) {
                this.thirst = Math.min(this.thirst + 1, 20);
                this.quenched = Math.min(this.quenched + 1, 20);
            }
            this.updateThirstData(player);
            this.syncTimer = 0;
        }
        if (this.thirst <= 0) {
            ++this.damageTimer;
            if (this.damageTimer >= 40) {
                if (player.getHealth() > 10.0f || difficulty == Difficulty.HARD || player.getHealth() > 0.0f && difficulty == Difficulty.NORMAL) {
                    player.hurt(ModDamageSource.getDamageSource(player.level(), ModDamageSource.DIE_OF_THIRST_KEY), 1.0f);
                }
                this.damageTimer = 0;
            }
        }
    }

    void updateExhaustion(Player player) {
        float normalizedHungerExhaustion;
        float hungerExhaustion = player.getFoodData().getExhaustionLevel();
        float f = hungerExhaustion < this.prevTickExhaustion ? (this.exhaustionRecalculate ? hungerExhaustion + 4.0f : hungerExhaustion) : (normalizedHungerExhaustion = hungerExhaustion);
        if (this.exhaustionRecalculate) {
            this.exhaustionRecalculate = false;
        }
        float deltaExhaustion = normalizedHungerExhaustion - this.prevTickExhaustion;
        this.addExhaustion(player, deltaExhaustion);
        this.prevTickExhaustion = hungerExhaustion;
    }

    @Override
    public void updateThirstData(Player player) {
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new PlayerThirstSyncMessage(this.thirst, this.quenched, this.exhaustion, this.shouldTickThirst), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void setJustHealed() {
        this.justHealed = true;
    }

    @Override
    public void ExhaustionRecalculate() {
        this.exhaustionRecalculate = true;
    }

    @Override
    public void copy(IThirst cap) {
        this.thirst = cap.getThirst();
        this.quenched = cap.getQuenched();
        this.exhaustion = cap.getExhaustion();
        this.shouldTickThirst = cap.getShouldTickThirst();
    }

    @Override
    public void addExhaustion(Player player, float amount) {
        if (!((Boolean)CommonConfig.HEALTH_REGEN_DEPLETES_HYDRATION.get()).booleanValue() && this.justHealed) {
            amount = 0.0f;
        }
        this.exhaustion = !((Boolean)CommonConfig.HEALTH_REGEN_DEHYDRATION_IS_BIOME_DEPENDENT.get()).booleanValue() && this.justHealed ? (this.exhaustion += amount) : (this.exhaustion += amount * ThirstHelper.getExhaustionBiomeModifier(player) * ThirstHelper.getExhaustionFireProtModifier(player) * ThirstHelper.getExhaustionFireResistanceModifier(player));
        if (this.justHealed) {
            this.justHealed = false;
        }
        this.updateThirstData(player);
    }

    public @UnknownNullability CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("thirst", this.thirst);
        nbt.putInt("quenched", this.quenched);
        nbt.putFloat("exhaustion", this.exhaustion);
        nbt.putBoolean("enable", this.shouldTickThirst);
        return nbt;
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, CompoundTag nbt) {
        this.thirst = nbt.getInt("thirst");
        this.quenched = nbt.getInt("quenched");
        this.exhaustion = nbt.getFloat("exhaustion");
        this.shouldTickThirst = !nbt.contains("enable") || nbt.getBoolean("enable");
    }
}

