/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.compat.create;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.ghen.thirst.compat.create.CreateRegistry;
import dev.ghen.thirst.content.purity.WaterPurity;
import dev.ghen.thirst.foundation.config.CommonConfig;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class SandFilterBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public static final int TANK_SIZE = 1000;
    SmartFluidTankBehaviour dirtyTank;
    SmartFluidTankBehaviour purifiedTank;

    public SandFilterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.dirtyTank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.dirtyTank);
        this.purifiedTank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.purifiedTank);
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().expandTowards(0.0, -2.0, 0.0);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CreateRegistry.SAND_FILTER_BE.get(), (be, side) -> {
            if (side != null && side.getAxis() == Direction.Axis.Y) {
                if (side == Direction.DOWN) {
                    return be.purifiedTank.getCapability();
                }
                return be.dirtyTank.getCapability();
            }
            return null;
        });
    }

    public void tick() {
        super.tick();
        if (!this.level.isClientSide() && this.dirtyTank.getPrimaryHandler().getFluidAmount() >= ((Number)CommonConfig.SAND_FILTER_MB_PER_TICK.get()).intValue() && this.purifiedTank.getPrimaryHandler().getFluidAmount() < 1000) {
            FluidStack water = this.dirtyTank.getPrimaryHandler().drain(((Number)CommonConfig.SAND_FILTER_MB_PER_TICK.get()).intValue(), IFluidHandler.FluidAction.EXECUTE);
            if (water.getFluid().equals(Fluids.WATER)) {
                WaterPurity.addPurity(water, Math.min(WaterPurity.getPurity(water) + ((Number)CommonConfig.SAND_FILTER_FILTRATION_AMOUNT.get()).intValue(), 3));
            }
            this.purifiedTank.getPrimaryHandler().fill(water, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        CreateLang.translate((String)"gui.goggles.fluid_container", (Object[])new Object[0]).forGoggles(tooltip);
        int dirtyWaterAmount = this.dirtyTank.getPrimaryHandler().getFluidAmount();
        int purifiedWaterAmount = this.purifiedTank.getPrimaryHandler().getFluidAmount();
        this.buildTooltip(tooltip, mb, dirtyWaterAmount, this.dirtyTank);
        this.buildTooltip(tooltip, mb, purifiedWaterAmount, this.purifiedTank);
        if (this.dirtyTank.isEmpty() && this.purifiedTank.isEmpty()) {
            CreateLang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(CreateLang.number((double)this.dirtyTank.getPrimaryHandler().getTankCapacity(0)).add(mb).style(ChatFormatting.GOLD)).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        }
        return !this.dirtyTank.isEmpty() || !this.purifiedTank.isEmpty();
    }

    private void buildTooltip(List<Component> tooltip, LangBuilder mb, int purifiedWaterAmount, SmartFluidTankBehaviour purifiedTank) {
        if (!purifiedTank.isEmpty()) {
            CreateLang.builder().text(WaterPurity.getPurityText(WaterPurity.getPurity(purifiedTank.getPrimaryHandler().getFluid()))).add(CreateLang.text((String)" ")).add(CreateLang.fluidName((FluidStack)purifiedTank.getPrimaryHandler().getFluid())).style(ChatFormatting.GRAY).forGoggles(tooltip);
            CreateLang.builder().add(CreateLang.number((double)purifiedWaterAmount).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)purifiedTank.getPrimaryHandler().getCapacity()).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        }
    }
}

