/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.api;

import com.momosoftworks.coldsweat.api.util.Temperature;
import dev.ghen.thirst.compat.supernatural.SupernaturalHelper;
import dev.ghen.thirst.content.purity.ContainerWithPurity;
import dev.ghen.thirst.content.purity.WaterPurity;
import dev.ghen.thirst.content.registry.ThirstComponent;
import dev.ghen.thirst.foundation.common.event.ThirstEventFactory;
import dev.ghen.thirst.foundation.config.CommonConfig;
import dev.ghen.thirst.foundation.config.ContainerConfig;
import dev.ghen.thirst.foundation.config.ItemSettingsConfig;
import dev.ghen.thirst.foundation.config.KeyWordConfig;
import dev.ghen.thirst.foundation.util.ConfigHelper;
import dev.ghen.thirst.foundation.util.LoadedValue;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.fml.ModList;

public class ThirstHelper {
    private static boolean useColdSweatCaps = false;
    private static final float MODIFIER_HARSHNESS = 0.5f;
    public static Map<Item, Number[]> VALID_DRINKS = LoadedValue.of(() -> ConfigHelper.getItemsWithValues((List)ItemSettingsConfig.DRINKS.get())).get();
    public static Map<Item, Number[]> VALID_FOODS = LoadedValue.of(() -> ConfigHelper.getItemsWithValues((List)ItemSettingsConfig.FOODS.get())).get();
    public static List<Item> containers = LoadedValue.of(() -> ConfigHelper.getItems((List)ContainerConfig.CONTAINERS.get())).get();
    public static String keywordBlackList = (String)KeyWordConfig.KEYWORD_BLACKLIST.get();
    public static String keywordDrink = (String)KeyWordConfig.KEYWORD_DRINK.get();
    public static String keywordSoup = (String)KeyWordConfig.KEYWORD_SOUP.get();
    public static String keywordFruit = (String)KeyWordConfig.KEYWORD_FRUIT.get();

    public static void init() {
        ThirstEventFactory.onRegisterThirstValue();
        for (Item item : containers) {
            if (item.equals(Items.AIR)) continue;
            WaterPurity.addContainer(new ContainerWithPurity(item));
        }
    }

    public static boolean itemRestoresThirst(ItemStack itemStack) {
        return ThirstHelper.isDrink(itemStack) || ThirstHelper.isFood(itemStack) || ThirstHelper.checkKeywords(itemStack);
    }

    public static boolean playerRestoresThirst(ItemStack itemStack, Player player) {
        if (ModList.get().isLoaded("supernatural")) {
            return SupernaturalHelper.canDrinkItem(itemStack, player);
        }
        return true;
    }

    public static boolean isDrink(ItemStack itemStack) {
        return !((List)ItemSettingsConfig.ITEMS_BLACKLIST.get()).contains(itemStack.getItem().toString()) && VALID_DRINKS.containsKey(itemStack.getItem());
    }

    public static boolean isFood(ItemStack itemStack) {
        return !((List)ItemSettingsConfig.ITEMS_BLACKLIST.get()).contains(itemStack.getItem().toString()) && VALID_FOODS.containsKey(itemStack.getItem());
    }

    @Deprecated(forRemoval=true, since="1.3.8")
    public static void addFood(Item item, int thirst, int quenched) {
    }

    @Deprecated(forRemoval=true, since="1.3.8")
    public static void addDrink(Item item, int thirst, int quenched) {
    }

    public static int getThirst(ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (VALID_DRINKS.containsKey(item)) {
            return VALID_DRINKS.get(item)[0].intValue();
        }
        return VALID_FOODS.get(item)[0].intValue();
    }

    public static int getQuenched(ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (VALID_DRINKS.containsKey(item)) {
            return VALID_DRINKS.get(item)[1].intValue();
        }
        return VALID_FOODS.get(item)[1].intValue();
    }

    public static int getPurity(ItemStack item) {
        if (!WaterPurity.hasPurity(item)) {
            return (Integer)CommonConfig.DEFAULT_PURITY.get();
        }
        return (Integer)item.get(ThirstComponent.PURITY);
    }

    public static void shouldUseColdSweatCaps(boolean should) {
        useColdSweatCaps = should;
    }

    public static float getExhaustionFireProtModifier(Player player) {
        float perLevelMultiplier = 0.0625f;
        float totalLevels = EnchantmentHelper.getDamageProtection((ServerLevel)((ServerLevel)player.level()), (LivingEntity)player, (DamageSource)player.damageSources().onFire()) / 2.0f;
        if (totalLevels > 12.0f) {
            totalLevels = 12.0f;
        }
        return 1.0f - totalLevels * 0.0625f * 0.75f;
    }

    public static float getExhaustionFireResistanceModifier(Player player) {
        if (player.hasEffect(MobEffects.FIRE_RESISTANCE)) {
            return (float)((Integer)CommonConfig.FIRE_RESISTANCE_DEHYDRATION.get()).intValue() / 100.0f;
        }
        return 1.0f;
    }

    public static float getExhaustionBiomeModifier(Player player) {
        BlockPos pos = player.getOnPos();
        Level level = player.level();
        if (level.dimensionType().ultraWarm()) {
            return ((Double)CommonConfig.NETHER_THIRST_DEPLETION_MODIFIER.get()).floatValue();
        }
        Biome biome = (Biome)level.getBiome(pos).value();
        float humidity = biome.getModifiedClimateSettings().downfall() + 0.6f;
        if ((double)humidity <= 0.6) {
            humidity = (float)((double)humidity + 0.5);
        }
        float temp = biome.getBaseTemperature() + 0.2f;
        if (useColdSweatCaps) {
            temp = (float)(Temperature.get((LivingEntity)player, (Temperature.Trait)Temperature.Trait.BODY) / 100.0);
        } else if (temp <= 0.0f) {
            temp = (float)Math.exp(temp);
        } else if (temp > 1.0f) {
            temp /= 2.0f;
        }
        float thirstModifier = ((Number)CommonConfig.THIRST_DEPLETION_MODIFIER.get()).floatValue() * (temp / humidity);
        if (thirstModifier < 1.0f) {
            float modifierOffset = 1.0f - thirstModifier;
            thirstModifier = 1.0f - (modifierOffset *= 0.5f);
        }
        return thirstModifier;
    }

    private static boolean checkKeywords(ItemStack itemStack) {
        if (!((Boolean)KeyWordConfig.ENABLE_KEYWORD_CONFIG.get()).booleanValue()) {
            return false;
        }
        if (itemStack.getFoodProperties(null) != null) {
            return false;
        }
        String pattern = keywordBlackList;
        Matcher matcher = Pattern.compile(pattern, 2).matcher(itemStack.getDescriptionId());
        if (matcher.find()) {
            return false;
        }
        pattern = keywordDrink;
        matcher = Pattern.compile(pattern, 2).matcher(itemStack.getDescriptionId());
        boolean hasWater = matcher.find();
        if (hasWater) {
            VALID_DRINKS.put(itemStack.getItem(), new Number[]{KeyWordConfig.getDrinkHydration(), KeyWordConfig.getDrinkQuenchness()});
            return true;
        }
        pattern = keywordSoup;
        matcher = Pattern.compile(pattern, 2).matcher(itemStack.getDescriptionId());
        hasWater = matcher.find();
        if (hasWater) {
            VALID_FOODS.put(itemStack.getItem(), new Number[]{KeyWordConfig.getSoupHydration(), KeyWordConfig.getSoupQuenchness()});
            return true;
        }
        pattern = keywordFruit;
        matcher = Pattern.compile(pattern, 2).matcher(itemStack.getDescriptionId());
        hasWater = matcher.find();
        if (hasWater) {
            VALID_FOODS.put(itemStack.getItem(), new Number[]{KeyWordConfig.getFruitHydration(), KeyWordConfig.getFruitQuenchness()});
        }
        return hasWater;
    }
}

