/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.network.ClientReceivers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientBoundParticlePacket
implements Message {
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ClientBoundParticlePacket> CODEC = Message.makeType((ResourceLocation)Supplementaries.res("s2c_particle"), ClientBoundParticlePacket::new);
    public final Kind type;
    @Nullable
    public final Vec3 pos;
    private final int @NotNull [] extraData;
    @Nullable
    public final Vec3 dir;

    public ClientBoundParticlePacket(RegistryFriendlyByteBuf buffer) {
        this.type = (Kind)buffer.readEnum(Kind.class);
        this.extraData = buffer.readVarIntArray();
        this.pos = buffer.readBoolean() ? new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()) : null;
        this.dir = buffer.readBoolean() ? new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()) : null;
    }

    public ClientBoundParticlePacket(BlockPos pos, Kind type) {
        this(Vec3.atCenterOf((Vec3i)pos), type);
    }

    public ClientBoundParticlePacket(Vec3 pos, Kind type) {
        this(pos, type, null);
    }

    public ClientBoundParticlePacket(Vec3 pos, Kind type, Integer extraData) {
        this(pos, type, null, extraData);
    }

    public ClientBoundParticlePacket(Vec3 pos, Kind type, @Nullable Vec3 direction, int ... extraData) {
        this.pos = pos;
        this.type = type;
        this.dir = direction;
        this.extraData = extraData;
    }

    public ClientBoundParticlePacket(Entity entity, Kind type) {
        this(entity, type, null);
    }

    public ClientBoundParticlePacket(Entity entity, Kind type, Vec3 dir) {
        this.extraData = new int[]{entity.getId()};
        this.type = type;
        this.pos = null;
        this.dir = dir;
    }

    public void write(RegistryFriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.type);
        buffer.writeVarIntArray(this.extraData);
        if (this.pos != null) {
            buffer.writeBoolean(true);
            buffer.writeDouble(this.pos.x);
            buffer.writeDouble(this.pos.y);
            buffer.writeDouble(this.pos.z);
        } else {
            buffer.writeBoolean(false);
        }
        if (this.dir != null) {
            buffer.writeBoolean(true);
            buffer.writeDouble(this.dir.x);
            buffer.writeDouble(this.dir.y);
            buffer.writeDouble(this.dir.z);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public void handle(Message.Context context) {
        ClientReceivers.handleSpawnBlockParticlePacket(this);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CODEC.type();
    }

    public List<Integer> getExtraData() {
        return Arrays.stream(this.extraData).boxed().collect(Collectors.toList());
    }

    @Nullable
    public Integer getFirstExtraData() {
        if (this.extraData.length > 0) {
            return this.extraData[0];
        }
        return null;
    }

    public static enum Kind {
        BUBBLE_BLOW,
        BUBBLE_CLEAN,
        BUBBLE_CLEAN_ENTITY,
        BUBBLE_EAT,
        DISPENSER_MINECART,
        FLINT_BLOCK_IGNITE,
        WAX_ON,
        GLOW_ON,
        CONFETTI,
        CONFETTI_EXPLOSION,
        FEATHER,
        WRENCH_ROTATION,
        PEARL_TELEPORT,
        BOMB_EXPLOSION;

    }
}

