/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.crafting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.misc.HolderRef;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.items.AntiqueInkItem;
import net.mehvahdjukaar.supplementaries.common.items.BambooSpikesTippedItem;
import net.mehvahdjukaar.supplementaries.common.items.components.BlackboardData;
import net.mehvahdjukaar.supplementaries.common.items.components.ConfettiColors;
import net.mehvahdjukaar.supplementaries.common.items.crafting.RecipeSpecialDisplayOutput;
import net.mehvahdjukaar.supplementaries.common.utils.SoapWashableHelper;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;

public class SpecialRecipeDisplays {
    private static List<RecipeHolder<? extends CraftingRecipe>> createAntiqueMapRecipe() {
        ArrayList<RecipeHolder<? extends CraftingRecipe>> recipes = new ArrayList<RecipeHolder<? extends CraftingRecipe>>();
        String group = "supplementaries.antique_map";
        ItemStack stack = new ItemStack((ItemLike)Items.FILLED_MAP);
        stack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"filled_map.antique"));
        AntiqueInkItem.setAntiqueInk(stack, true);
        Ingredient ink = Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModRegistry.ANTIQUE_INK.get())});
        Ingredient map = Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.FILLED_MAP)});
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{map, ink});
        ResourceLocation id = Supplementaries.res("antique_map_create_display");
        ShapelessRecipe recipe = new ShapelessRecipe(group, CraftingBookCategory.MISC, stack, inputs);
        recipes.add(new RecipeHolder(id, (Recipe)recipe));
        return recipes;
    }

    private static List<RecipeHolder<? extends CraftingRecipe>> createAntiqueBookRecipe() {
        ArrayList<RecipeHolder<? extends CraftingRecipe>> recipes = new ArrayList<RecipeHolder<? extends CraftingRecipe>>();
        String group = "supplementaries.antique_book";
        ItemStack stack = new ItemStack((ItemLike)Items.WRITTEN_BOOK);
        AntiqueInkItem.setAntiqueInk(stack, true);
        Ingredient ink = Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModRegistry.ANTIQUE_INK.get())});
        Ingredient map = Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.WRITTEN_BOOK)});
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{map, ink});
        ResourceLocation id = Supplementaries.res("/antique_book_create_display");
        ShapelessRecipe recipe = new ShapelessRecipe(group, CraftingBookCategory.MISC, stack, inputs);
        recipes.add(new RecipeHolder(id, (Recipe)recipe));
        return recipes;
    }

    private static List<RecipeHolder<? extends CraftingRecipe>> createRopeArrowCreateRecipe() {
        ArrayList<RecipeHolder<? extends CraftingRecipe>> recipes = new ArrayList<RecipeHolder<? extends CraftingRecipe>>();
        String group = "supplementaries.rope_arrow";
        ItemStack ropeArrow = new ItemStack((ItemLike)ModRegistry.ROPE_ARROW_ITEM.get());
        ropeArrow.setDamageValue(ropeArrow.getMaxDamage() - 4);
        Ingredient arrow = Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.ARROW)});
        Ingredient rope = Ingredient.of(ModTags.ROPES);
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{arrow, rope, rope, rope, rope});
        ResourceLocation id = Supplementaries.res("/rope_arrow_create_display");
        ShapelessRecipe recipe = new ShapelessRecipe(group, CraftingBookCategory.EQUIPMENT, ropeArrow, inputs);
        recipes.add(new RecipeHolder(id, (Recipe)recipe));
        return recipes;
    }

    private static List<RecipeHolder<? extends CraftingRecipe>> createRopeArrowAddRecipe() {
        ArrayList<RecipeHolder<? extends CraftingRecipe>> recipes = new ArrayList<RecipeHolder<? extends CraftingRecipe>>();
        String group = "supplementaries.rope_arrow_add";
        ItemStack ropeArrow = new ItemStack((ItemLike)ModRegistry.ROPE_ARROW_ITEM.get());
        ItemStack ropeArrow2 = ropeArrow.copy();
        ropeArrow2.setDamageValue(8);
        Ingredient arrow = Ingredient.of((ItemStack[])new ItemStack[]{ropeArrow2});
        Ingredient rope = Ingredient.of(ModTags.ROPES);
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{rope, rope, rope, rope, arrow, rope, rope, rope, rope});
        ResourceLocation id = Supplementaries.res("/rope_arrow_add_display");
        ShapelessRecipe recipe = new ShapelessRecipe(group, CraftingBookCategory.EQUIPMENT, ropeArrow, inputs);
        recipes.add(new RecipeHolder(id, (Recipe)recipe));
        return recipes;
    }

    private static List<RecipeHolder<? extends CraftingRecipe>> createSoapCleanRecipe() {
        ArrayList<RecipeHolder<? extends CraftingRecipe>> recipes = new ArrayList<RecipeHolder<? extends CraftingRecipe>>();
        String group = "supplementaries.soap";
        for (String k : BlocksColorAPI.getBlockKeys()) {
            HolderSet n;
            Item out = BlocksColorAPI.getColoredItem((String)k, null);
            if (out == null || !SoapWashableHelper.canCleanColor(out) || (n = BlocksColorAPI.getItemHolderSet((String)k)) == null) continue;
            Ingredient ing = (Ingredient)n.unwrap().map(Ingredient::of, l -> Ingredient.of(l.stream().map(Holder::value).map(Item::getDefaultInstance)));
            NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{ing, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.SOAP.get()})});
            ItemStack output = out.getDefaultInstance();
            ResourceLocation id = Supplementaries.res("/soap_clean_" + k.replace(":", "_"));
            ShapelessRecipe recipe = new ShapelessRecipe(group, CraftingBookCategory.MISC, output, inputs);
            recipes.add((RecipeHolder<? extends CraftingRecipe>)new RecipeHolder(id, (Recipe)recipe));
        }
        return recipes;
    }

    private static List<RecipeHolder<? extends CraftingRecipe>> createTrappedPresentRecipes() {
        ArrayList<RecipeHolder<? extends CraftingRecipe>> recipes = new ArrayList<RecipeHolder<? extends CraftingRecipe>>();
        String group = "supplementaries.trapped_presents";
        for (DyeColor color : DyeColor.values()) {
            Ingredient baseShulkerIngredient = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.PRESENTS.get(color).get()});
            ItemStack output = ModRegistry.TRAPPED_PRESENTS.get(color).get().asItem().getDefaultInstance();
            NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{baseShulkerIngredient, Ingredient.of((ItemLike[])new ItemLike[]{Items.TRIPWIRE_HOOK})});
            ResourceLocation id = Supplementaries.res("/trapped_present_" + color.getName() + "_display");
            ShapelessRecipe shapelessRecipe = new ShapelessRecipe(group, CraftingBookCategory.BUILDING, output, inputs);
            recipes.add((RecipeHolder<? extends CraftingRecipe>)new RecipeHolder(id, (Recipe)shapelessRecipe));
        }
        Ingredient ingredients = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.PRESENTS.get(null).get()});
        ItemStack output = ModRegistry.TRAPPED_PRESENTS.get(null).get().asItem().getDefaultInstance();
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{ingredients, Ingredient.of((ItemLike[])new ItemLike[]{Items.TRIPWIRE_HOOK})});
        ResourceLocation id = Supplementaries.res("trapped_present_display");
        ShapelessRecipe shapelessRecipe = new ShapelessRecipe(group, CraftingBookCategory.BUILDING, output, inputs);
        recipes.add(new RecipeHolder(id, (Recipe)shapelessRecipe));
        return recipes;
    }

    private static List<RecipeHolder<? extends CraftingRecipe>> createPresentColoringRecipes() {
        ArrayList<RecipeHolder<? extends CraftingRecipe>> recipes = new ArrayList<RecipeHolder<? extends CraftingRecipe>>();
        String group = "presents";
        Ingredient ingredients = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.PRESENTS.get(null).get()});
        for (DyeColor color : DyeColor.values()) {
            DyeItem dye = DyeItem.byColor((DyeColor)color);
            ItemStack output = ModRegistry.PRESENTS.get(color).get().asItem().getDefaultInstance();
            NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{ingredients, Ingredient.of((ItemLike[])new ItemLike[]{dye})});
            ResourceLocation id = Supplementaries.res("/present_" + color.getName() + "_display");
            ShapelessRecipe shapelessRecipe = new ShapelessRecipe(group, CraftingBookCategory.BUILDING, output, inputs);
            recipes.add((RecipeHolder<? extends CraftingRecipe>)new RecipeHolder(id, (Recipe)shapelessRecipe));
        }
        return recipes;
    }

    private static List<RecipeHolder<? extends CraftingRecipe>> createSackColoringRecipes() {
        ArrayList<RecipeHolder<? extends CraftingRecipe>> recipes = new ArrayList<RecipeHolder<? extends CraftingRecipe>>();
        String group = "sacks";
        Ingredient ingredients = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.SACK.get()});
        for (DyeColor color : DyeColor.values()) {
            DyeItem dye = DyeItem.byColor((DyeColor)color);
            Item output = BlocksColorAPI.changeColor((Item)ModRegistry.SACK.get().asItem(), (DyeColor)color);
            if (output == null) break;
            NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{ingredients, Ingredient.of((ItemLike[])new ItemLike[]{dye})});
            ResourceLocation id = Supplementaries.res("/sack_" + color.getName() + "_display");
            ShapelessRecipe shapelessRecipe = new ShapelessRecipe(group, CraftingBookCategory.BUILDING, output.getDefaultInstance(), inputs);
            recipes.add((RecipeHolder<? extends CraftingRecipe>)new RecipeHolder(id, (Recipe)shapelessRecipe));
        }
        return recipes;
    }

    private static List<RecipeHolder<? extends CraftingRecipe>> createConfettiDye() {
        ArrayList<RecipeHolder<? extends CraftingRecipe>> recipes = new ArrayList<RecipeHolder<? extends CraftingRecipe>>();
        String group = "confetti_dye";
        Ingredient ingredients = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.CONFETTI_POPPER.get()});
        for (DyeColor color : DyeColor.values()) {
            DyeItem dye = DyeItem.byColor((DyeColor)color);
            ItemStack output = ModRegistry.CONFETTI_POPPER.get().getDefaultInstance();
            output.set(ModComponents.CONFETTI_COLORS.get(), (Object)ConfettiColors.of(dye.getDyeColor().getTextureDiffuseColor()));
            NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{ingredients, Ingredient.of((ItemLike[])new ItemLike[]{dye})});
            ResourceLocation id = Supplementaries.res("/confetti_" + color.getName() + "_display");
            ShapelessRecipe shapelessRecipe = new ShapelessRecipe(group, CraftingBookCategory.MISC, output, inputs);
            recipes.add((RecipeHolder<? extends CraftingRecipe>)new RecipeHolder(id, (Recipe)shapelessRecipe));
        }
        return recipes;
    }

    private static List<RecipeHolder<? extends CraftingRecipe>> createItemLoreRecipe() {
        ArrayList<RecipeHolder<? extends CraftingRecipe>> recipes = new ArrayList<RecipeHolder<? extends CraftingRecipe>>();
        String group = "item_lore";
        ItemStack output = new ItemStack((ItemLike)Items.SLIME_BALL);
        ItemStack tag = new ItemStack((ItemLike)Items.NAME_TAG);
        MutableComponent c = Component.literal((String)"Ew sticky!");
        tag.set(DataComponents.ITEM_NAME, (Object)c);
        output.set(DataComponents.LORE, (Object)new ItemLore(List.of(c)));
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.SLIME_BALL}), Ingredient.of((ItemStack[])new ItemStack[]{tag})});
        ResourceLocation id = Supplementaries.res("/item_lore_display");
        ShapelessRecipe recipe = new ShapelessRecipe(group, CraftingBookCategory.MISC, output, inputs);
        recipes.add(new RecipeHolder(id, (Recipe)recipe));
        return recipes;
    }

    private static List<RecipeHolder<? extends CraftingRecipe>> createRemoveLoreRecipe() {
        ArrayList<RecipeHolder<? extends CraftingRecipe>> recipes = new ArrayList<RecipeHolder<? extends CraftingRecipe>>();
        String group = "remove_lore";
        ItemStack output = new ItemStack((ItemLike)Items.COCOA_BEANS);
        ItemStack soap = new ItemStack((ItemLike)ModRegistry.SOAP.get());
        MutableComponent c = Component.literal((String)"Stinky!");
        ItemStack input = output.copy();
        input.set(DataComponents.LORE, (Object)new ItemLore(List.of(c)));
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemStack[])new ItemStack[]{input}), Ingredient.of((ItemStack[])new ItemStack[]{soap})});
        ResourceLocation id = Supplementaries.res("/remove_lore_display");
        ShapelessRecipe recipe = new ShapelessRecipe(group, CraftingBookCategory.MISC, output, inputs);
        recipes.add(new RecipeHolder(id, (Recipe)recipe));
        return recipes;
    }

    private static List<RecipeHolder<? extends CraftingRecipe>> createSusRecipe() {
        ArrayList<RecipeHolder<? extends CraftingRecipe>> recipes = new ArrayList<RecipeHolder<? extends CraftingRecipe>>();
        String group = "sus_crafting";
        HashMap<Block, Block> blocks = new HashMap<Block, Block>();
        if (CommonConfigs.Tweaks.SUS_RECIPES.get().booleanValue()) {
            blocks.put(Blocks.SAND, Blocks.SUSPICIOUS_SAND);
            blocks.put(Blocks.GRAVEL, Blocks.SUSPICIOUS_GRAVEL);
            if (CommonConfigs.Building.GRAVEL_BRICKS_ENABLED.get().booleanValue()) {
                blocks.put(ModRegistry.GRAVEL_BRICKS.get(), ModRegistry.SUS_GRAVEL_BRICKS.get());
            }
        }
        ItemStack content = Items.GOLD_INGOT.getDefaultInstance();
        content.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)"Precious Item"));
        for (Map.Entry e : blocks.entrySet()) {
            ItemStack output = new ItemStack((ItemLike)e.getValue());
            ItemStack input = new ItemStack((ItemLike)e.getKey());
            NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemStack[])new ItemStack[]{input}), Ingredient.of((ItemStack[])new ItemStack[]{content})});
            ResourceLocation id = Supplementaries.res("/" + Utils.getID((Item)output.getItem()).getPath());
            ShapelessRecipe recipe = new ShapelessRecipe(group, CraftingBookCategory.MISC, output, inputs);
            recipes.add((RecipeHolder<? extends CraftingRecipe>)new RecipeHolder(id, (Recipe)recipe));
        }
        return recipes;
    }

    private static List<RecipeHolder<? extends CraftingRecipe>> createBubbleBlowerChargeRecipe() {
        ArrayList<RecipeHolder<? extends CraftingRecipe>> recipes = new ArrayList<RecipeHolder<? extends CraftingRecipe>>();
        String group = "bubble_blower";
        ItemStack ropeArrow = new ItemStack((ItemLike)ModRegistry.BUBBLE_BLOWER.get());
        ItemStack empty = ropeArrow.copy();
        empty.setDamageValue(empty.getMaxDamage());
        Ingredient base = Ingredient.of((ItemStack[])new ItemStack[]{empty});
        Ingredient soap = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.SOAP.get()});
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{base, soap});
        ResourceLocation id = Supplementaries.res("/bubble_blower_charge_display");
        ShapelessRecipe recipe = new ShapelessRecipe(group, CraftingBookCategory.MISC, ropeArrow, inputs);
        recipes.add(new RecipeHolder(id, (Recipe)recipe));
        return recipes;
    }

    private static List<RecipeHolder<? extends CraftingRecipe>> createSafeRecipe() {
        ArrayList<RecipeHolder<? extends CraftingRecipe>> recipes = new ArrayList<RecipeHolder<? extends CraftingRecipe>>();
        String group = "safe";
        ItemStack safe = new ItemStack((ItemLike)ModRegistry.SAFE.get());
        Ingredient base = Ingredient.of(ModTags.SHULKER_BOXES);
        Ingredient ingot = Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT});
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{base, ingot});
        ShapelessRecipe recipe = new ShapelessRecipe(group, CraftingBookCategory.MISC, safe, inputs);
        recipes.add(new RecipeHolder(Supplementaries.res("/safe_display"), (Recipe)recipe));
        return recipes;
    }

    private static List<RecipeHolder<? extends CraftingRecipe>> createTippedBambooSpikesRecipes() {
        ArrayList<RecipeHolder<? extends CraftingRecipe>> recipes = new ArrayList<RecipeHolder<? extends CraftingRecipe>>();
        String group = "tipped_spikes";
        for (Holder.Reference potionType : BuiltInRegistries.POTION.holders().toList()) {
            if (((Potion)potionType.value()).getEffects().isEmpty() || !BambooSpikesTippedItem.isPotionValid(new PotionContents((Holder)potionType))) continue;
            recipes.add(SpecialRecipeDisplays.makeSpikeRecipe((Holder<Potion>)potionType, group));
        }
        return recipes;
    }

    private static RecipeHolder<ShapelessRecipe> makeSpikeRecipe(Holder<Potion> potionType, String group) {
        ItemStack spikes = new ItemStack((ItemLike)ModRegistry.BAMBOO_SPIKES.get());
        ItemStack lingeringPotion = PotionContents.createItemStack((Item)Items.LINGERING_POTION, potionType);
        Ingredient spikeIngredient = Ingredient.of((ItemStack[])new ItemStack[]{spikes});
        Ingredient potionIngredient = Ingredient.of((ItemStack[])new ItemStack[]{lingeringPotion});
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{spikeIngredient, potionIngredient});
        ItemStack output = BambooSpikesTippedItem.createItemStack(potionType);
        ResourceLocation id = Supplementaries.res("/" + Potion.getName(Optional.of(potionType), (String)"tipped_spikes_display."));
        ShapelessRecipe recipe = new ShapelessRecipe(group, CraftingBookCategory.BUILDING, output, inputs);
        return new RecipeHolder(id, (Recipe)recipe);
    }

    private static List<RecipeHolder<? extends CraftingRecipe>> createFlagFromBanner() {
        ArrayList<RecipeHolder<? extends CraftingRecipe>> recipes = new ArrayList<RecipeHolder<? extends CraftingRecipe>>();
        String group = "flag_from_banner";
        for (DyeColor color : DyeColor.values()) {
            ItemStack banner = new ItemStack((ItemLike)BannerBlock.byColor((DyeColor)color).asItem());
            ItemStack fullFlag = new ItemStack((ItemLike)ModRegistry.FLAGS.get(color).get());
            BannerPatternLayers patterns = new BannerPatternLayers(List.of(new BannerPatternLayers.Layer(HolderRef.of((ResourceKey)BannerPatterns.BASE).getHolder((HolderLookup.Provider)Utils.hackyGetRegistryAccess()), color == DyeColor.WHITE ? DyeColor.BLACK : DyeColor.WHITE)));
            banner.set(DataComponents.BANNER_PATTERNS, (Object)patterns);
            fullFlag.set(DataComponents.BANNER_PATTERNS, (Object)patterns);
            Ingredient emptyFlag = Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModRegistry.FLAGS.get(color).get())});
            NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{emptyFlag, Ingredient.of((ItemStack[])new ItemStack[]{banner})});
            ResourceLocation id = Supplementaries.res("/flag_from_banner_display_" + color.getName());
            ShapelessRecipe recipe = new ShapelessRecipe(group, CraftingBookCategory.BUILDING, fullFlag, inputs);
            recipes.add((RecipeHolder<? extends CraftingRecipe>)new RecipeHolder(id, (Recipe)recipe));
        }
        return recipes;
    }

    private static List<RecipeHolder<? extends CraftingRecipe>> createBlackboardDuplicate() {
        ArrayList<RecipeHolder<? extends CraftingRecipe>> recipes = new ArrayList<RecipeHolder<? extends CraftingRecipe>>();
        String group = "supplementaries.blackboard_duplicate";
        ItemStack blackboard = SpecialRecipeDisplays.getTroll();
        Ingredient emptyBoard = Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModRegistry.BLACKBOARD_ITEM.get())});
        Ingredient fullBoard = Ingredient.of((ItemStack[])new ItemStack[]{blackboard});
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{emptyBoard, fullBoard});
        ResourceLocation id = Supplementaries.res("/blackboard_duplicate_display");
        ShapelessRecipe recipe = new ShapelessRecipe(group, CraftingBookCategory.BUILDING, blackboard, inputs);
        recipes.add(new RecipeHolder(id, (Recipe)recipe));
        return recipes;
    }

    private static ItemStack getTroll() {
        ItemStack blackboard = new ItemStack((ItemLike)ModRegistry.BLACKBOARD_ITEM.get());
        CompoundTag com = new CompoundTag();
        byte[][] pixels = new byte[][]{{0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0}, {0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0}, {0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 0}, {0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0}, {0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0}, {0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0}, {0, 0, 1, 0, 0, 1, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0}, {0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0}, {0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0}};
        blackboard.set(ModComponents.BLACKBOARD.get(), (Object)new BlackboardData(pixels, false, false));
        return blackboard;
    }

    private static ItemStack getSans() {
        ItemStack blackboard = new ItemStack((ItemLike)ModRegistry.BLACKBOARD_ITEM.get());
        CompoundTag com = new CompoundTag();
        byte[][] pixels = new byte[][]{{0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0}, {0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 1, 0}, {0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 0}, {0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1}, {0, 1, 0, 0, 0, 0, 0, 3, 0, 0, 0, 1, 1, 1, 0, 1}, {0, 1, 0, 0, 0, 3, 3, 3, 3, 0, 0, 1, 0, 1, 0, 1}, {0, 1, 0, 0, 3, 0, 3, 0, 3, 0, 0, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 0, 0, 3, 3, 3, 0, 1, 1, 0, 0, 1, 0}, {0, 0, 1, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0}};
        blackboard.set(ModComponents.BLACKBOARD.get(), (Object)new BlackboardData(pixels, false, false));
        return blackboard;
    }

    public static void registerCraftingRecipes(RecipeSpecialDisplayOutput<CraftingRecipe> registry) {
        for (RecipeBookCategories c : (List)RecipeBookCategories.AGGREGATE_CATEGORIES.get(RecipeBookCategories.CRAFTING_SEARCH)) {
            SpecialRecipeDisplays.registerRecipes(c, registry);
        }
    }

    public static void registerRecipes(RecipeBookCategories category, RecipeSpecialDisplayOutput<CraftingRecipe> registry) {
        if (category == RecipeBookCategories.CRAFTING_MISC) {
            registry.add("bamboo_spikes_tipped", SpecialRecipeDisplays::createTippedBambooSpikesRecipes);
            registry.add("flags/flag_from_banner", SpecialRecipeDisplays::createFlagFromBanner);
            registry.add("safe", SpecialRecipeDisplays::createSafeRecipe);
            registry.add("antique_map", SpecialRecipeDisplays::createAntiqueMapRecipe);
            registry.add("antique_book", SpecialRecipeDisplays::createAntiqueBookRecipe);
            registry.add("suppsquared:sack_dye", SpecialRecipeDisplays::createSackColoringRecipes);
            registry.add("item_lore", SpecialRecipeDisplays::createItemLoreRecipe);
            registry.add("item_lore_clear", SpecialRecipeDisplays::createRemoveLoreRecipe);
            registry.add("soap/clear", SpecialRecipeDisplays::createSoapCleanRecipe);
            registry.add("present_dye", SpecialRecipeDisplays::createPresentColoringRecipes);
            registry.add("trapped_present", SpecialRecipeDisplays::createTrappedPresentRecipes);
            registry.add("sus_crafting", SpecialRecipeDisplays::createSusRecipe);
            registry.add("confetti_popper_dye", SpecialRecipeDisplays::createConfettiDye);
        } else if (category == RecipeBookCategories.CRAFTING_BUILDING_BLOCKS) {
            registry.add("blackboard_duplicate", SpecialRecipeDisplays::createBlackboardDuplicate);
        } else if (category == RecipeBookCategories.CRAFTING_EQUIPMENT) {
            registry.add("rope_arrow_create", SpecialRecipeDisplays::createRopeArrowCreateRecipe);
            registry.add("rope_arrow_add", SpecialRecipeDisplays::createRopeArrowAddRecipe);
            registry.add("bubble_blower_charge", SpecialRecipeDisplays::createBubbleBlowerChargeRecipe);
        }
    }
}

