/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import net.mehvahdjukaar.supplementaries.common.utils.VibeChecker;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SpeedometerItem
extends Item {
    public SpeedometerItem(Item.Properties properties) {
        super(properties);
    }

    private static double roundToSignificantFigures(double num, int n) {
        if (num == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = Math.round(num * magnitude);
        return (double)shifted / magnitude;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (player.level().isClientSide) {
            this.calculateSpeed(player, (Entity)entity);
        }
        return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
    }

    private void calculateSpeed(Player player, Entity entity) {
        double speed = SpeedometerItem.getBPS(entity);
        double s = SpeedometerItem.roundToSignificantFigures(speed, 3);
        player.displayClientMessage((Component)Component.translatable((String)"message.supplementaries.speedometer", (Object[])new Object[]{s}), true);
    }

    private static double getBPS(Entity entity) {
        Entity mount = entity.getVehicle();
        Entity e = entity;
        if (mount != null) {
            e = mount;
        }
        Vec3 v = e.getDeltaMovement();
        if (e.onGround()) {
            v = v.subtract(0.0, v.y, 0.0);
        }
        return v.length() * 20.0;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        VibeChecker.assertSameLevel(level, player);
        if (level.isClientSide) {
            this.calculateSpeed(player, (Entity)player);
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public static class SpeedometerItemProperty
    implements ItemPropertyFunction {
        public float call(ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity player, int seed) {
            LivingEntity entity;
            Object object = entity = player != null ? player : stack.getEntityRepresentation();
            if (entity == null) {
                return 0.0f;
            }
            double speed = SpeedometerItem.getBPS((Entity)entity);
            double max = 60.0;
            return (float)Math.min(speed / max, 1.0);
        }
    }
}

