/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.faucet;

import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetTarget;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FluidOffer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

class WaterCauldronInteraction
implements FaucetTarget.BlState,
FaucetSource.BlState {
    WaterCauldronInteraction() {
    }

    @Override
    public FluidOffer getProvidedFluid(Level level, BlockPos pos, Direction dir, BlockState source) {
        if (source.is(Blocks.WATER_CAULDRON)) {
            return FluidOffer.of((Holder<SoftFluid>)MLBuiltinSoftFluids.WATER.getHolder(level), (int)((Integer)source.getValue((Property)LayeredCauldronBlock.LEVEL)));
        }
        return null;
    }

    @Override
    public void drain(Level level, BlockPos pos, Direction dir, BlockState source, int amount) {
        int am = (Integer)source.getValue((Property)LayeredCauldronBlock.LEVEL) - amount;
        if (am <= 0) {
            level.setBlock(pos, Blocks.CAULDRON.defaultBlockState(), 3);
        } else {
            level.setBlockAndUpdate(pos, (BlockState)source.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(am)));
        }
    }

    @Override
    public Integer fill(Level level, BlockPos pos, BlockState state, FluidOffer offer) {
        if (state.is(Blocks.CAULDRON) && offer.fluid().is(MLBuiltinSoftFluids.WATER)) {
            int minAmount = offer.minAmount();
            int am = Math.min(minAmount, 3);
            level.setBlockAndUpdate(pos, (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(am)));
            return minAmount;
        }
        if (state.is(Blocks.WATER_CAULDRON)) {
            SoftFluidStack fluid = offer.fluid();
            if (fluid.is(MLBuiltinSoftFluids.WATER) && (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL) < 3) {
                int amount = fluid.getCount();
                int space = 3 - (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL);
                int am = Math.min(amount, space);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf((Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL) + am)));
                return Math.max(offer.minAmount(), am);
            }
            return 0;
        }
        return null;
    }
}

