/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.client.util.ParticleUtil;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractPresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.TrappedPresentBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TrappedPresentBlock
extends AbstractPresentBlock
implements ILightable {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty ON_COOLDOWN = BlockStateProperties.TRIGGERED;

    public TrappedPresentBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(color, properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ON_COOLDOWN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, ON_COOLDOWN});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new TrappedPresentBlockTile(pPos, pState);
    }

    public boolean triggerEvent(BlockState pState, Level pLevel, BlockPos pPos, int pId, int pParam) {
        if (pId == 0 && ((Boolean)pState.getValue((Property)ON_COOLDOWN)).booleanValue()) {
            if (pLevel.isClientSide) {
                RandomSource random = pLevel.random;
                double cx = (double)pPos.getX() + 0.5;
                double cy = (double)pPos.getY() + 0.5 + 0.4;
                double cz = (double)pPos.getZ() + 0.5;
                for (int i = 0; i < 10; ++i) {
                    double speed = random.nextDouble() * 0.15 + 0.015;
                    double py = cy + 0.02 + (random.nextDouble() - 0.5) * 0.3;
                    double dx = random.nextGaussian() * 0.01;
                    double dy = speed + random.nextGaussian() * 0.01;
                    double dz = random.nextGaussian() * 0.01;
                    pLevel.addParticle((ParticleOptions)ParticleTypes.CLOUD, cx, py, cz, dx, dy, dz);
                }
                ParticleUtil.spawnBreakParticles((VoxelShape)PresentBlock.SHAPE_LID, (BlockPos)pPos, (BlockState)pState, (Level)pLevel);
            }
            return true;
        }
        return super.triggerEvent(pState, pLevel, pPos, pId, pParam);
    }

    @Override
    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        if (((Boolean)state.getValue((Property)ON_COOLDOWN)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ON_COOLDOWN, (Comparable)Boolean.valueOf(false)));
        }
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, world, pos, block, fromPos, isMoving);
        boolean isPowered = world.hasNeighborSignal(pos);
        if (isPowered) {
            this.tryLightUp(null, state, pos, (LevelAccessor)world, ILightable.FireSoundType.FIRE_CHANGE);
        }
    }

    public boolean isLitUp(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)PACKED) == false;
    }

    public void setLitUp(BlockState blockState, LevelAccessor level, BlockPos pos, @Nullable Entity entity, boolean b) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TrappedPresentBlockTile) {
            TrappedPresentBlockTile tile = (TrappedPresentBlockTile)blockEntity;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                tile.detonate((LevelAccessor)serverLevel, pos, blockState, null);
            }
        }
    }

    public void playLightUpSound(LevelAccessor world, BlockPos pos, ILightable.FireSoundType type) {
    }
}

