/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ColorRGBA;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RakedGravelBlock
extends ColoredFallingBlock {
    public static final MapCodec<RakedGravelBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ColorRGBA.CODEC.fieldOf("falling_dust_color").forGetter(coloredFallingBlock -> coloredFallingBlock.dustColor), (App)RakedGravelBlock.propertiesCodec()).apply((Applicative)instance, RakedGravelBlock::new));
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final EnumProperty<ModBlockProperties.RakeDirection> RAKE_DIRECTION = ModBlockProperties.RAKE_DIRECTION;

    public RakedGravelBlock(ColorRGBA color, BlockBehaviour.Properties properties) {
        super(color, properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_SOUTH)));
    }

    public MapCodec<ColoredFallingBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{RAKE_DIRECTION});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = super.defaultBlockState();
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        if (!blockstate.canSurvive((LevelReader)world, pos)) {
            return Block.pushEntitiesUp((BlockState)blockstate, (BlockState)Blocks.GRAVEL.defaultBlockState(), (LevelAccessor)world, (BlockPos)pos);
        }
        Direction front = context.getHorizontalDirection();
        return RakedGravelBlock.getConnectedState(blockstate, (LevelAccessor)world, pos, front);
    }

    private static boolean canConnect(BlockState state, Direction dir) {
        if (state.getBlock() == ModRegistry.RAKED_GRAVEL.get()) {
            return ((ModBlockProperties.RakeDirection)((Object)state.getValue(RAKE_DIRECTION))).getDirections().contains(dir.getOpposite());
        }
        return false;
    }

    public static BlockState getConnectedState(BlockState blockstate, LevelAccessor world, BlockPos pos, Direction front) {
        ArrayList<Direction> directionList = new ArrayList<Direction>();
        Direction back = front.getOpposite();
        if (RakedGravelBlock.canConnect(world.getBlockState(pos.relative(back)), back)) {
            directionList.add(back);
        } else {
            directionList.add(front);
        }
        Direction side = front.getClockWise();
        for (int i = 0; i < 2; ++i) {
            BlockState state = world.getBlockState(pos.relative(side));
            if (RakedGravelBlock.canConnect(state, side)) {
                directionList.add(side);
                break;
            }
            side = side.getOpposite();
        }
        return (BlockState)blockstate.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.fromDirections(directionList)));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        ModBlockProperties.RakeDirection shape = (ModBlockProperties.RakeDirection)((Object)state.getValue(RAKE_DIRECTION));
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> {
                switch (shape) {
                    case SOUTH_EAST: {
                        yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_WEST));
                    }
                    case SOUTH_WEST: {
                        yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_EAST));
                    }
                    case NORTH_WEST: {
                        yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.SOUTH_EAST));
                    }
                    case NORTH_EAST: {
                        yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.SOUTH_WEST));
                    }
                }
                yield state;
            }
            case Rotation.COUNTERCLOCKWISE_90 -> {
                switch (shape) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case SOUTH_EAST: {
                        yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_EAST));
                    }
                    case SOUTH_WEST: {
                        yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.SOUTH_EAST));
                    }
                    case NORTH_WEST: {
                        yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.SOUTH_WEST));
                    }
                    case NORTH_EAST: {
                        yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_WEST));
                    }
                    case NORTH_SOUTH: {
                        yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.EAST_WEST));
                    }
                    case EAST_WEST: 
                }
                yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_SOUTH));
            }
            case Rotation.CLOCKWISE_90 -> {
                switch (shape) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case SOUTH_EAST: {
                        yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.SOUTH_WEST));
                    }
                    case SOUTH_WEST: {
                        yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_WEST));
                    }
                    case NORTH_WEST: {
                        yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_EAST));
                    }
                    case NORTH_EAST: {
                        yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.SOUTH_EAST));
                    }
                    case NORTH_SOUTH: {
                        yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.EAST_WEST));
                    }
                    case EAST_WEST: 
                }
                yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_SOUTH));
            }
            default -> state;
        };
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        ModBlockProperties.RakeDirection shape = (ModBlockProperties.RakeDirection)((Object)state.getValue(RAKE_DIRECTION));
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> {
                switch (shape) {
                    case SOUTH_EAST: {
                        yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_EAST));
                    }
                    case SOUTH_WEST: {
                        yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_WEST));
                    }
                    case NORTH_WEST: {
                        yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.SOUTH_WEST));
                    }
                    case NORTH_EAST: {
                        yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.SOUTH_EAST));
                    }
                }
                yield super.mirror(state, mirror);
            }
            case Mirror.FRONT_BACK -> {
                switch (shape) {
                    case SOUTH_EAST: {
                        yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.SOUTH_WEST));
                    }
                    case SOUTH_WEST: {
                        yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.SOUTH_EAST));
                    }
                    case NORTH_WEST: {
                        yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_EAST));
                    }
                    case NORTH_EAST: {
                        yield (BlockState)state.setValue(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_WEST));
                    }
                }
                yield super.mirror(state, mirror);
            }
            default -> super.mirror(state, mirror);
        };
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState fromState, LevelAccessor world, BlockPos pos, BlockPos fromPos) {
        if (direction == Direction.UP && !state.canSurvive((LevelReader)world, pos)) {
            world.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, direction, fromState, world, pos, fromPos);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            RakedGravelBlock.turnToGravel(state, (Level)world, pos);
        }
        super.tick(state, world, pos, random);
    }

    public static void turnToGravel(BlockState state, Level world, BlockPos pos) {
        world.setBlockAndUpdate(pos, RakedGravelBlock.pushEntitiesUp((BlockState)state, (BlockState)Blocks.GRAVEL.defaultBlockState(), (LevelAccessor)world, (BlockPos)pos));
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos.above());
        return !blockstate.isSolid() || blockstate.getBlock() instanceof FenceGateBlock;
    }
}

