/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.supplementaries.common.block.tiles.KeyLockableTile;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class GoldDoorBlock
extends DoorBlock {
    public GoldDoorBlock(BlockBehaviour.Properties builder) {
        super(BlockSetType.GOLD, builder);
    }

    public boolean canBeOpened(BlockState state) {
        return (Boolean)state.getValue((Property)POWERED) == false;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (this.canBeOpened(state)) {
            GoldDoorBlock.tryOpenDoubleDoor(level, state, pos);
            state = (BlockState)state.cycle((Property)OPEN);
            level.setBlock(pos, state, 10);
            this.playSound((Entity)player, level, pos, (Boolean)state.getValue((Property)OPEN));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean hasPower;
        boolean bl = worldIn.hasNeighborSignal(pos) || worldIn.hasNeighborSignal(pos.relative(state.getValue((Property)HALF) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN)) ? true : (hasPower = false);
        if (blockIn != this && hasPower != (Boolean)state.getValue((Property)POWERED)) {
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(hasPower)), 2);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state != null) {
            state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public static void tryOpenDoubleDoor(Level world, BlockState state, BlockPos pos) {
        if (CompatHandler.QUARK && QuarkCompat.isDoubleDoorEnabled() || CompatHandler.DOUBLEDOORS) {
            Direction direction = (Direction)state.getValue((Property)DoorBlock.FACING);
            boolean isOpen = (Boolean)state.getValue((Property)DoorBlock.OPEN);
            DoorHingeSide isMirrored = (DoorHingeSide)state.getValue((Property)DoorBlock.HINGE);
            BlockPos mirrorPos = pos.relative(isMirrored == DoorHingeSide.RIGHT ? direction.getCounterClockWise() : direction.getClockWise());
            BlockPos doorPos = state.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.LOWER ? mirrorPos : mirrorPos.below();
            BlockState other = world.getBlockState(doorPos);
            if (other.getBlock() == state.getBlock() && other.getValue((Property)DoorBlock.FACING) == direction && !((Boolean)other.getValue((Property)DoorBlock.POWERED)).booleanValue() && (Boolean)other.getValue((Property)DoorBlock.OPEN) == isOpen && other.getValue((Property)DoorBlock.HINGE) != isMirrored) {
                BlockState newState = (BlockState)other.cycle((Property)DoorBlock.OPEN);
                world.setBlock(doorPos, newState, 10);
            }
        }
    }

    public static void tryOpenDoubleDoorKey(Level world, BlockState state, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        if (CompatHandler.QUARK && QuarkCompat.isDoubleDoorEnabled() || CompatHandler.DOUBLEDOORS) {
            KeyLockableTile keyLockableTile;
            BlockEntity blockEntity;
            Direction direction = (Direction)state.getValue((Property)DoorBlock.FACING);
            boolean isOpen = (Boolean)state.getValue((Property)DoorBlock.OPEN);
            DoorHingeSide isMirrored = (DoorHingeSide)state.getValue((Property)DoorBlock.HINGE);
            BlockPos mirrorPos = pos.relative(isMirrored == DoorHingeSide.RIGHT ? direction.getCounterClockWise() : direction.getClockWise());
            BlockPos doorPos = state.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.LOWER ? mirrorPos : mirrorPos.below();
            BlockState other = world.getBlockState(doorPos);
            if (other.getBlock() == state.getBlock() && other.getValue((Property)DoorBlock.FACING) == direction && (Boolean)other.getValue((Property)DoorBlock.OPEN) == isOpen && other.getValue((Property)DoorBlock.HINGE) != isMirrored && (blockEntity = world.getBlockEntity(doorPos)) instanceof KeyLockableTile && (keyLockableTile = (KeyLockableTile)blockEntity).handleAction(player, hand, stack, "door")) {
                BlockState newState = (BlockState)other.cycle((Property)DoorBlock.OPEN);
                world.setBlock(doorPos, newState, 10);
            }
        }
    }
}

