/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.base.Preconditions;
import net.mehvahdjukaar.moonlight.api.block.IBeeGrowable;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FlaxBlock
extends CropBlock
implements IBeeGrowable {
    public static final int DOUBLE_AGE = 4;
    private static final VoxelShape FULL_BOTTOM = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape[] SHAPES_BOTTOM = new VoxelShape[]{Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), FULL_BOTTOM, FULL_BOTTOM, FULL_BOTTOM};
    private static final VoxelShape[] SHAPES_TOP = new VoxelShape[]{FULL_BOTTOM, FULL_BOTTOM, FULL_BOTTOM, FULL_BOTTOM, Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)};
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;

    public FlaxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return SHAPES_BOTTOM[(Integer)state.getValue((Property)AGE)];
        }
        return SHAPES_TOP[(Integer)state.getValue((Property)AGE)];
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)stateIn.getValue(HALF);
        if (facing.getAxis() != Direction.Axis.Y || half == DoubleBlockHalf.LOWER != (facing == Direction.UP) || this.isSingle(stateIn) || facingState.is((Block)this) && facingState.getValue(HALF) != half) {
            return half == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        return Blocks.AIR.defaultBlockState();
    }

    public boolean isSingle(BlockState state) {
        return this.getAge(state) < 4;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (!state.is((Block)this)) {
            throw new IllegalArgumentException("Somebody (a mod) passed a [" + String.valueOf(Utils.getID((Block)state.getBlock())) + "] blockstate to a member function of [Flax] block. This breaks a contract");
        }
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            BlockState above = worldIn.getBlockState(pos.above());
            if (above.getBlock() == this && this.isSingle(above)) {
                return false;
            }
            return super.canSurvive(state, worldIn, pos);
        }
        if (this.isSingle(state)) {
            return false;
        }
        BlockState blockstate = worldIn.getBlockState(pos.below());
        if (state.getBlock() != this) {
            return super.canSurvive(state, worldIn, pos);
        }
        return blockstate.is((Block)this) && blockstate.getValue(HALF) == DoubleBlockHalf.LOWER && this.getAge(state) == this.getAge(blockstate);
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.isClientSide) {
            if (player.isCreative()) {
                FlaxBlock.removeBottomHalf(worldIn, pos, state, player);
            } else {
                FlaxBlock.dropResources((BlockState)state, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
            }
        }
        return super.playerWillDestroy(worldIn, pos, state, player);
    }

    public void playerDestroy(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.playerDestroy(worldIn, player, pos, Blocks.AIR.defaultBlockState(), te, stack);
    }

    protected static void removeBottomHalf(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.getValue(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = world.getBlockState(blockpos = pos.below())).getBlock() == state.getBlock() && blockstate.getValue(HALF) == DoubleBlockHalf.LOWER) {
            world.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 35);
            world.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HALF});
    }

    public void placeAt(LevelAccessor worldIn, BlockPos pos, int flags) {
        worldIn.setBlock(pos, (BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.LOWER), flags);
        worldIn.setBlock(pos.above(), (BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), flags);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float f;
        if (!PlatHelper.isAreaLoaded((LevelReader)level, (BlockPos)pos, (int)1)) {
            return;
        }
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return;
        }
        if (level.getRawBrightness(pos, 0) >= 9 && this.isValidBonemealTarget((LevelReader)level, pos, state) && ForgeHelper.fireOnCropsGrowPre((ServerLevel)level, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / (f = SuppPlatformStuff.getGrowthSpeed(state, level, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            this.growCropBy((Level)level, pos, state, 1);
            ForgeHelper.fireOnCropsGrowPost((ServerLevel)level, (BlockPos)pos, (BlockState)state);
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        Preconditions.checkArgument((boolean)state.is((Block)this), (Object)"Some mod passed a block that is not this own to the use method. This is bad!");
        InteractionResult old = super.useWithoutItem(state, level, pos, player, hitResult);
        if (!old.consumesAction() && !this.isSingle(state) && state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            InteractionResult ev = ForgeHelper.fireOnRightClickBlock((Player)player, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)pos.below(), (BlockHitResult)hitResult);
            if (ev != null) {
                return ev;
            }
            BlockState below = level.getBlockState(pos.below());
            if (below.is((Block)this)) {
                return this.useWithoutItem(below, level, pos.below(), player, hitResult);
            }
        }
        return old;
    }

    public boolean canGrowUp(BlockGetter worldIn, BlockPos downPos) {
        BlockState state = worldIn.getBlockState(downPos.above());
        return state.getBlock() instanceof FlaxBlock || state.canBeReplaced();
    }

    public boolean isValidBonemealTarget(LevelReader worldIn, BlockPos pos, BlockState state) {
        return !this.isMaxAge(state) && (this.canGrowUp((BlockGetter)worldIn, pos) || this.getAge(state) < 3);
    }

    public void growCrops(Level level, BlockPos pos, BlockState state) {
        this.growCropBy(level, pos, state, this.getBonemealAgeIncrease(level));
    }

    public void growCropBy(Level level, BlockPos pos, BlockState state, int increment) {
        if (increment > 1 && this.isSingle(state) && !this.canGrowUp((BlockGetter)level, pos)) {
            increment = 1;
        }
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            pos = pos.below();
        }
        int newAge = this.getAge(state) + increment;
        if ((newAge = Math.min(newAge, this.getMaxAge())) >= 4) {
            level.setBlock(pos.above(), (BlockState)this.getStateForAge(newAge).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
        }
        level.setBlock(pos, this.getStateForAge(newAge), 3);
    }

    public boolean canBeReplaced(BlockState pState, BlockPlaceContext pUseContext) {
        return false;
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)ModRegistry.FLAX_SEEDS_ITEM.get();
    }

    public boolean getPollinated(Level level, BlockPos pos, BlockState state) {
        this.growCropBy(level, pos, state, 1);
        return true;
    }
}

