/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.items;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.UUID;
import java.util.WeakHashMap;
import net.mehvahdjukaar.supplementaries.client.renderers.CapturedMobCache;
import net.mehvahdjukaar.supplementaries.client.renderers.items.ProjectileWeaponOverlayRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.items.SlingshotRendererHelper;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.CageBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModEnchantments;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class SlingshotItemOverlayRenderer
extends ProjectileWeaponOverlayRenderer {
    private final WeakHashMap<CompoundTag, Entity> cachedParrots = new WeakHashMap();
    private UUID lastUUID = null;

    @Override
    public boolean render(GuiGraphics graphics, Font font, ItemStack stack, int x, int y) {
        boolean overlay = ClientConfigs.Items.SLINGSHOT_OVERLAY.get();
        boolean outline = ClientConfigs.Items.SLINGSHOT_OUTLINE.get();
        if (overlay || outline) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null && (player.getMainHandItem() == stack || player.getOffhandItem() == stack)) {
                if (overlay && !this.renderParrot((Player)player, graphics, font, stack, x, y)) {
                    ItemStack ammo = this.getAmmoForPreview(stack, (Level)Minecraft.getInstance().level, (Player)player);
                    SlingshotItemOverlayRenderer.renderAmmo(graphics, x, y, ammo);
                }
                if (outline && EnchantmentHelper.has((ItemStack)stack, ModEnchantments.PROJECTILE_NO_GRAVITY.get())) {
                    SlingshotRendererHelper.grabNewLookPos((Player)player);
                }
            }
            return true;
        }
        return false;
    }

    private boolean renderParrot(Player player, GuiGraphics graphics, Font font, ItemStack stack, int x, int y) {
        CompoundTag firstParrot = player.getShoulderEntityLeft();
        if (firstParrot.isEmpty()) {
            firstParrot = player.getShoulderEntityRight();
        }
        if (firstParrot.isEmpty()) {
            return false;
        }
        if (!firstParrot.contains("UUID")) {
            return false;
        }
        UUID id = firstParrot.getUUID("UUID");
        Entity e = CapturedMobCache.getOrCreateCachedMob(player.level(), id, firstParrot);
        if (e == null) {
            return false;
        }
        e.setPos(0.0, 0.0, 0.0);
        e.setYRot(0.0f);
        e.setYBodyRot(0.0f);
        e.setYHeadRot(0.0f);
        e.setXRot(0.0f);
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        float xOff = 17.0f;
        float yOff = 10.0f;
        float a = 0.0f;
        AABB bb = e.getBoundingBox();
        float scale = (float)((double)0.7f * Math.max(bb.getXsize(), bb.getYsize()));
        poseStack.translate(-4.0 + (double)((xOff + (float)x) * (1.0f - a)), 4.4 + (double)((yOff + (float)y) * (1.0f - a)), (double)(16.0f + 200.0f * (1.0f - a)));
        poseStack.scale(scale, -scale, scale);
        RenderSystem.applyModelViewMatrix();
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        poseStack.mulPose(Axis.XP.rotationDegrees(30.0f));
        EntityRenderDispatcher entityRenderer = Minecraft.getInstance().getEntityRenderDispatcher();
        CageBlockTileRenderer.renderMobStatic(e, 16.0f, entityRenderer, graphics.pose(), 1.0f, (MultiBufferSource)bufferSource, 0xF000F0, 45.0f);
        poseStack.popPose();
        RenderSystem.applyModelViewMatrix();
        return true;
    }
}

