/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.entities.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Iterator;
import net.mehvahdjukaar.supplementaries.client.IModelPartExtension;
import net.mehvahdjukaar.supplementaries.client.renderers.SlimedRenderTypes;
import net.mehvahdjukaar.supplementaries.common.entities.data.SlimedData;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.EMFCompat;
import net.mehvahdjukaar.supplementaries.mixins.AgeableListAccessor;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.LivingEntity;

public class SlimedLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public SlimedLayer(RenderLayerParent<T, M> parent) {
        super(parent);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        float alpha = SlimedData.getAlpha(entity, partialTicks);
        if (alpha == 0.0f) {
            return;
        }
        int width = 64;
        int height = 64;
        EntityModel model = this.getParentModel();
        ModelPart modelPart = null;
        if (CompatHandler.EMF) {
            modelPart = EMFCompat.getFirstEMFModelPart((Model)model);
        }
        if (modelPart == null && model instanceof AgeableListAccessor) {
            AgeableListAccessor al = (AgeableListAccessor)model;
            Iterator<ModelPart> iterator = al.invokeBodyParts().iterator();
            if (iterator.hasNext()) {
                ModelPart v;
                modelPart = v = iterator.next();
            }
        } else if (model instanceof HierarchicalModel) {
            HierarchicalModel m = (HierarchicalModel)model;
            modelPart = m.root();
        }
        if (modelPart != null) {
            IModelPartExtension part = (IModelPartExtension)modelPart;
            height = part.supp$getTextHeight();
            width = part.supp$getTextWidth();
        }
        VertexConsumer consumer = buffer.getBuffer(SlimedRenderTypes.get(width, height));
        poseStack.pushPose();
        model.renderToBuffer(poseStack, consumer, packedLight, LivingEntityRenderer.getOverlayCoords(entity, (float)0.0f), FastColor.ARGB32.color((int)((int)(alpha * 255.0f)), (int)255, (int)255, (int)255));
        poseStack.popPose();
    }
}

