/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.almanac.util;

import com.frikinjay.almanac.platform.ConfigHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class ItemNBTUtil {
    private static volatile List<Pattern> blacklistPattern = null;
    private static final Set<Item> blacklistCache = new HashSet<Item>();
    private static final Set<Item> whitelistCache = new HashSet<Item>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkAndFix(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        if (blacklistCache.contains(item)) {
            return false;
        }
        if (whitelistCache.contains(item)) {
            return ItemNBTUtil.tryRemoveEmptyCustomData(stack);
        }
        List<Pattern> patterns = ItemNBTUtil.getOrInitializePatterns();
        if (patterns == null) {
            return false;
        }
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
        if (itemId == null) {
            Set<Item> set = blacklistCache;
            synchronized (set) {
                blacklistCache.add(item);
            }
            return false;
        }
        String id = itemId.toString();
        for (Pattern p : patterns) {
            if (!p.matcher(id).matches()) continue;
            Set<Item> set = blacklistCache;
            synchronized (set) {
                blacklistCache.add(item);
            }
            return false;
        }
        Set<Item> set = whitelistCache;
        synchronized (set) {
            whitelistCache.add(item);
        }
        return ItemNBTUtil.tryRemoveEmptyCustomData(stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Pattern> getOrInitializePatterns() {
        if (blacklistPattern != null) {
            return blacklistPattern;
        }
        Class<ItemNBTUtil> clazz = ItemNBTUtil.class;
        synchronized (ItemNBTUtil.class) {
            if (blacklistPattern != null) {
                // ** MonitorExit[clazz] (shouldn't be in output)
                return blacklistPattern;
            }
            try {
                List<? extends String> configList = ConfigHelper.blacklistItems();
                ArrayList<Pattern> patterns = new ArrayList<Pattern>();
                if (configList != null && !configList.isEmpty()) {
                    for (String string : configList) {
                        String regex = string.replace("*", ".*");
                        patterns.add(Pattern.compile(regex));
                    }
                }
                blacklistPattern = patterns;
                // ** MonitorExit[clazz] (shouldn't be in output)
                return patterns;
            }
            catch (Exception e) {
                // ** MonitorExit[clazz] (shouldn't be in output)
                return null;
            }
        }
    }

    private static boolean tryRemoveEmptyCustomData(ItemStack stack) {
        CustomData component = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (component != null && component.copyTag().isEmpty()) {
            stack.remove(DataComponents.CUSTOM_DATA);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void resetCache() {
        Set<Item> set = blacklistCache;
        synchronized (set) {
            blacklistCache.clear();
        }
        set = whitelistCache;
        synchronized (set) {
            whitelistCache.clear();
        }
        blacklistPattern = null;
    }

    @Deprecated
    public static void fixBug(ItemStack stack) {
        ItemNBTUtil.checkAndFix(stack);
    }
}

