/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.beautifiedchatserver_common_forge.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.natamus.beautifiedchatserver_common_forge.config.ConfigHandler;
import com.natamus.collective_common_forge.functions.DataFunctions;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class Util {
    private static final Path BASE_DIR = Paths.get(DataFunctions.getConfigDirectory(), "beautifiedchatserver");
    private static final Path RANKS_FILE = BASE_DIR.resolve("ranks.json");
    private static final Path PLAYERS_FILE = BASE_DIR.resolve("players.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static ChatFormatting getColour(String word, String playerName) {
        ChatFormatting colour = ChatFormatting.getById((int)ConfigHandler.chatOtherSymbolsColour);
        if (word.equalsIgnoreCase("timestamp")) {
            colour = ChatFormatting.getById((int)ConfigHandler.chatTimestampColour);
        } else if (word.equalsIgnoreCase("username")) {
            String playerRank;
            Optional<ChatFormatting> optionalRankColour;
            Optional<String> optionalPlayerRank;
            if (ConfigHandler.useRankColours && (optionalPlayerRank = Util.getRankOfPlayer(playerName)).isPresent() && (optionalRankColour = Util.getRankColor(playerRank = optionalPlayerRank.get())).isPresent()) {
                return optionalRankColour.get();
            }
            colour = ChatFormatting.getById((int)ConfigHandler.chatUsernameColour);
        } else if (word.equalsIgnoreCase("chatmessage")) {
            colour = ChatFormatting.getById((int)ConfigHandler.chatMessageColour);
        }
        return colour;
    }

    public static ChatFormatting parseColor(String s) {
        if (s == null) {
            return null;
        }
        try {
            return ChatFormatting.valueOf((String)s.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            for (ChatFormatting cf : ChatFormatting.values()) {
                if (!cf.isColor() || !cf.getName().equalsIgnoreCase(s)) continue;
                return cf;
            }
            return null;
        }
    }

    public static CompletableFuture<Suggestions> suggestsColors(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        for (ChatFormatting cf : ChatFormatting.values()) {
            if (!cf.isColor()) continue;
            builder.suggest(cf.getName());
        }
        return builder.buildFuture();
    }

    public static boolean addOrUpdateRank(String rankName, ChatFormatting color) {
        Util.ensureDirs();
        String r = Util.norm(rankName);
        JsonObject ranks = Util.readJsonObject(RANKS_FILE);
        String newColor = color.getName().toUpperCase(Locale.ROOT);
        if (ranks.has(r) && newColor.equals(Util.asString(ranks.get(r)))) {
            return false;
        }
        ranks.addProperty(r, newColor);
        Util.writeJsonObject(RANKS_FILE, ranks);
        return true;
    }

    public static boolean removeRank(String rankName) {
        Util.ensureDirs();
        String r = Util.norm(rankName);
        JsonObject ranks = Util.readJsonObject(RANKS_FILE);
        if (!ranks.has(r)) {
            return false;
        }
        ranks.remove(r);
        Util.writeJsonObject(RANKS_FILE, ranks);
        return true;
    }

    public static Optional<ChatFormatting> getRankColor(String rankName) {
        Util.ensureDirs();
        String r = Util.norm(rankName);
        JsonObject ranks = Util.readJsonObject(RANKS_FILE);
        if (!ranks.has(r)) {
            return Optional.empty();
        }
        String colorName = Util.asString(ranks.get(r));
        if (colorName == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(ChatFormatting.valueOf((String)colorName.toUpperCase(Locale.ROOT)));
        }
        catch (IllegalArgumentException ex) {
            for (ChatFormatting cf : ChatFormatting.values()) {
                if (!cf.getName().equalsIgnoreCase(colorName)) continue;
                return Optional.of(cf);
            }
            return Optional.empty();
        }
    }

    public static String togglePlayerRank(String playerName, String rankName) {
        String current;
        Util.ensureDirs();
        String p = Util.norm(playerName);
        String r = Util.norm(rankName);
        JsonObject players = Util.readJsonObject(PLAYERS_FILE);
        String string = current = players.has(p) ? Util.asString(players.get(p)) : null;
        if (r.equals(current)) {
            players.remove(p);
            Util.writeJsonObject(PLAYERS_FILE, players);
            return "removed";
        }
        players.addProperty(p, r);
        Util.writeJsonObject(PLAYERS_FILE, players);
        return "added";
    }

    public static Optional<String> getRankOfPlayer(String playerName) {
        Util.ensureDirs();
        String p = Util.norm(playerName);
        JsonObject players = Util.readJsonObject(PLAYERS_FILE);
        if (!players.has(p)) {
            return Optional.empty();
        }
        return Optional.ofNullable(Util.asString(players.get(p)));
    }

    private static void ensureDirs() {
        try {
            Files.createDirectories(BASE_DIR, new FileAttribute[0]);
            Util.ensureFile(RANKS_FILE);
            Util.ensureFile(PLAYERS_FILE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create config directories/files", e);
        }
    }

    private static void ensureFile(Path file) throws IOException {
        if (Files.notExists(file, new LinkOption[0])) {
            Util.writeJsonObject(file, new JsonObject());
        }
    }

    private static JsonObject readJsonObject(Path file) {
        try {
            if (Files.notExists(file, new LinkOption[0])) {
                return new JsonObject();
            }
            String text = Files.readString(file, StandardCharsets.UTF_8).trim();
            if (text.isEmpty()) {
                return new JsonObject();
            }
            JsonElement el = JsonParser.parseString((String)text);
            if (el.isJsonObject()) {
                return el.getAsJsonObject();
            }
            return new JsonObject();
        }
        catch (Exception e) {
            return new JsonObject();
        }
    }

    private static void writeJsonObject(Path file, JsonObject obj) {
        JsonObject sorted = Util.sortByKey(obj);
        try (BufferedWriter bw = Files.newBufferedWriter(file, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            GSON.toJson((JsonElement)sorted, (Appendable)bw);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write " + String.valueOf(file), e);
        }
    }

    private static JsonObject sortByKey(JsonObject obj) {
        ArrayList keys = new ArrayList(obj.keySet());
        Collections.sort(keys);
        JsonObject out = new JsonObject();
        for (String k : keys) {
            out.add(k, obj.get(k));
        }
        return out;
    }

    public static String asString(JsonElement el) {
        return el != null && el.isJsonPrimitive() && el.getAsJsonPrimitive().isString() ? el.getAsString() : null;
    }

    public static String norm(String s) {
        return s.toLowerCase(Locale.ROOT).trim();
    }

    public static boolean rankEquals(String a, String b) {
        if (a == null || b == null) {
            return false;
        }
        return Util.norm(a).equals(Util.norm(b));
    }

    public static JsonObject readJsonObjectSafe(String stringPath) {
        try {
            Path path = Paths.get(stringPath, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return new JsonObject();
            }
            String text = Files.readString(path, StandardCharsets.UTF_8).trim();
            if (text.isEmpty()) {
                return new JsonObject();
            }
            JsonElement el = JsonParser.parseString((String)text);
            return el.isJsonObject() ? el.getAsJsonObject() : new JsonObject();
        }
        catch (Exception ignored) {
            return new JsonObject();
        }
    }

    public static MutableComponent prefix() {
        return Component.literal((String)"[").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)"BCS").withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)"] ").withStyle(ChatFormatting.DARK_GRAY));
    }

    public static MutableComponent text(String s, ChatFormatting fmt) {
        return Component.literal((String)s).withStyle(fmt);
    }

    public static CompletableFuture<Suggestions> suggestRanks(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        JsonObject ranks = Util.readJsonObjectSafe(Util.ranksPathString());
        for (String key : Util.sortedKeys(ranks)) {
            builder.suggest(key);
        }
        return builder.buildFuture();
    }

    public static String ranksPathString() {
        return RANKS_FILE.toString();
    }

    public static String playersPathString() {
        return PLAYERS_FILE.toString();
    }

    public static Iterable<String> sortedKeys(JsonObject obj) {
        ArrayList<String> keys = new ArrayList<String>(obj.keySet());
        Collections.sort(keys);
        return keys;
    }
}

