/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.structure.exclusion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class EnhancedExclusionZone {
    public static final Codec<EnhancedExclusionZone> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.STRUCTURE_SET, (Codec)StructureSet.DIRECT_CODEC).fieldOf("other_set").forGetter(zone -> zone.otherSet), (App)Codec.intRange((int)1, (int)16).fieldOf("chunk_count").forGetter(zone -> zone.chunkCount)).apply((Applicative)builder, EnhancedExclusionZone::new));
    private final HolderSet<StructureSet> otherSet;
    private final int chunkCount;

    public EnhancedExclusionZone(HolderSet<StructureSet> otherSet, int chunkCount) {
        this.otherSet = otherSet;
        this.chunkCount = chunkCount;
    }

    public boolean isPlacementForbidden(ChunkGeneratorStructureState chunkGeneratorStructureState, int x, int z) {
        for (Holder holder : this.otherSet) {
            if (!chunkGeneratorStructureState.hasStructureChunkInRange(holder, x, z, this.chunkCount)) continue;
            return true;
        }
        return false;
    }
}

