/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.util;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;

public class CommonUtil {
    public static boolean isEntityInFluid(Entity entity, TagKey<Fluid> fluidTag) {
        if (entity.touchingUnloadedChunk()) {
            return false;
        }
        Level level = entity.level();
        AABB aabb = entity.getBoundingBox();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = Mth.floor((double)aabb.minX); x < Mth.ceil((double)aabb.maxX); ++x) {
            for (int y = Mth.floor((double)aabb.minY); y < Mth.ceil((double)aabb.maxY); ++y) {
                for (int z = Mth.floor((double)aabb.minZ); z < Mth.ceil((double)aabb.maxZ); ++z) {
                    double fluidHeight;
                    pos.set(x, y, z);
                    FluidState fluidState = level.getFluidState((BlockPos)pos);
                    if (!fluidState.is(fluidTag) || !((fluidHeight = (double)((float)y + fluidState.getHeight((BlockGetter)level, (BlockPos)pos))) >= aabb.minY)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

