/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.ticking.tickers.entity;

import einstein.subtle_effects.compat.CompatHelper;
import einstein.subtle_effects.compat.DyedFlamesCompat;
import einstein.subtle_effects.compat.PrometheusCompat;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.ticking.tickers.entity.EntityTicker;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.SparkType;
import einstein.subtle_effects.util.Util;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class EntityFireTicker
extends EntityTicker<Entity> {
    private final float bbWidth;
    private final float bbHeight;
    private final boolean isBlaze;

    public EntityFireTicker(Entity entity) {
        super(entity);
        this.isBlaze = this.entity.getType().equals(EntityType.BLAZE);
        this.bbWidth = entity.getBbWidth();
        this.bbHeight = entity.getBbHeight();
    }

    @Override
    public void entityTick() {
        if (this.entity.displayFireAnimation() || this.isBlaze) {
            float volume = ((Float)ModConfigs.ENTITIES.burning.soundVolume.get()).floatValue();
            if (volume > 0.0f && this.random.nextInt(90) == 0) {
                Util.playClientSound(this.entity, SoundEvents.FIRE_EXTINGUISH, this.entity.getSoundSource(), volume, 1.0f);
            }
            if (this.bbWidth <= 4.0f && this.bbHeight <= 4.0f) {
                ParticleOptions options;
                List<Integer> colors;
                if (!this.isBlaze && ModConfigs.ENTITIES.burning.smokeType.isEnabled() && this.random.nextDouble() < (double)((Float)ModConfigs.ENTITIES.burning.smokeDensity.get()).floatValue()) {
                    this.level.addParticle(ModConfigs.ENTITIES.burning.smokeType.getParticle().get(), this.entity.getRandomX(1.0), this.entity.getRandomY(), this.entity.getRandomZ(1.0), 0.0, 0.0, 0.0);
                }
                if (this.random.nextDouble() < (double)((Float)ModConfigs.ENTITIES.burning.sparksDensity.get()).floatValue() && (colors = this.getSparkColors()) != null) {
                    for (int i = 0; i < 2; ++i) {
                        this.level.addParticle((ParticleOptions)SparkParticle.create(SparkType.SHORT_LIFE, this.random, colors), this.entity.getRandomX(1.0), this.entity.getRandomY(), this.entity.getRandomZ(1.0), MathUtil.nextNonAbsDouble(this.random, 0.03), MathUtil.nextNonAbsDouble(this.random, 0.05), MathUtil.nextNonAbsDouble(this.random, 0.03));
                    }
                }
                if (this.bbWidth < 2.0f && this.bbHeight < 2.0f && !this.random.nextBoolean()) {
                    return;
                }
                if (this.random.nextDouble() < (double)((Float)ModConfigs.ENTITIES.burning.flamesDensity.get()).floatValue() && (options = this.getFlameParticle()) != null) {
                    this.level.addParticle(options, this.entity.getRandomX(1.0), this.entity.getRandomY(), this.entity.getRandomZ(1.0), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Nullable
    private ParticleOptions getFlameParticle() {
        if (CompatHelper.IS_PROMETHEUS_LOADED.get().booleanValue()) {
            return PrometheusCompat.getFlameParticle(this.entity);
        }
        if (CompatHelper.IS_DYED_FLAMES_LOADED.get().booleanValue()) {
            return DyedFlamesCompat.getFlameParticle(this.entity);
        }
        return ParticleTypes.FLAME;
    }

    @Nullable
    private List<Integer> getSparkColors() {
        if (this.isBlaze) {
            return SparkParticle.BLAZE_COLORS;
        }
        if (CompatHelper.IS_PROMETHEUS_LOADED.get().booleanValue()) {
            return PrometheusCompat.getSparkParticle(this.entity);
        }
        if (CompatHelper.IS_DYED_FLAMES_LOADED.get().booleanValue()) {
            return DyedFlamesCompat.getSparkParticle(this.entity);
        }
        return SparkParticle.DEFAULT_COLORS;
    }
}

