/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.ticking.tickers.entity;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.ticking.tickers.entity.EntityTicker;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class DrowningTicker
extends EntityTicker<LivingEntity> {
    public DrowningTicker(LivingEntity entity) {
        super(entity, true);
    }

    @Override
    public void entityTick() {
        if (((LivingEntity)this.entity).isSpectator() || ((LivingEntity)this.entity).getAirSupply() <= 0 || !((LivingEntity)this.entity).isUnderWater()) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        Entity entity = this.entity;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.equals((Object)minecraft.player) && !ModConfigs.ENTITIES.humanoids.drowningBubblesDisplayType.test(minecraft)) {
                return;
            }
            if (player.isCreative() && !ModConfigs.ENTITIES.humanoids.player.enableBreathingEffectsInCreative) {
                return;
            }
            if (player.isScoping() && minecraft.options.getCameraType().isFirstPerson()) {
                return;
            }
        }
        if (this.random.nextInt(30) < (Integer)ModConfigs.ENTITIES.humanoids.drowningBubblesDensity.get()) {
            ParticleSpawnUtil.spawnEntityFaceParticle((ParticleOptions)ModParticles.DROWNING_BUBBLE.get(), (LivingEntity)this.entity, this.level, new Vec3(0.0, -0.1, 0.0), Vec3.ZERO, Util.getPartialTicks());
        }
    }
}

