/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class VanillaFireflyParticle
extends TextureSheetParticle {
    private static final float PARTICLE_FADE_OUT_LIGHT_TIME = 0.3f;
    private static final float PARTICLE_FADE_IN_LIGHT_TIME = 0.1f;
    private static final float PARTICLE_FADE_OUT_ALPHA_TIME = 0.5f;
    private static final float PARTICLE_FADE_IN_ALPHA_TIME = 0.3f;
    private static final int PARTICLE_MIN_LIFETIME = 36;
    private static final int PARTICLE_MAX_LIFETIME = 180;

    private VanillaFireflyParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.speedUpWhenYMotionIsBlocked = true;
        this.friction = 0.96f;
        this.quadSize *= 0.75f;
        this.yd *= 0.8;
        this.xd *= 0.8;
        this.zd *= 0.8;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public int getLightColor(float partialTick) {
        return (int)(255.0f * VanillaFireflyParticle.getFadeAmount(this.getLifetimeProgress((float)this.age + partialTick), 0.1f, 0.3f));
    }

    public void tick() {
        super.tick();
        if (!this.level.getBlockState(BlockPos.containing((double)this.x, (double)this.y, (double)this.z)).isAir()) {
            this.remove();
            return;
        }
        this.setAlpha(VanillaFireflyParticle.getFadeAmount(this.getLifetimeProgress(this.age), 0.3f, 0.5f));
        if (this.random.nextDouble() > 0.95 || this.age == 1) {
            this.setParticleSpeed(-0.05 + 0.1 * this.random.nextDouble(), -0.05 + 0.1 * this.random.nextDouble(), -0.05 + 0.1 * this.random.nextDouble());
        }
    }

    private float getLifetimeProgress(float age) {
        return Mth.clamp((float)(age / (float)this.lifetime), (float)0.0f, (float)1.0f);
    }

    private static float getFadeAmount(float lifetimeProgress, float fadeIn, float fadeOut) {
        if (lifetimeProgress >= 1.0f - fadeIn) {
            return (1.0f - lifetimeProgress) / fadeIn;
        }
        return lifetimeProgress <= fadeOut ? lifetimeProgress / fadeOut : 1.0f;
    }

    public record FireflyProvider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            VanillaFireflyParticle particle = new VanillaFireflyParticle(level, x, y, z, 0.5 - level.random.nextDouble(), level.random.nextBoolean() ? ySpeed : -ySpeed, 0.5 - level.random.nextDouble());
            particle.setLifetime(level.random.nextIntBetweenInclusive(36, 180));
            particle.scale(1.5f);
            particle.pickSprite(this.sprites);
            particle.setAlpha(0.0f);
            return particle;
        }
    }
}

