/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.particle.option.ColorAndIntegerParticleOptions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class PotionDotParticle
extends TextureSheetParticle {
    @Nullable
    private final Entity entity;
    private final boolean hasEntity;
    private double xDistance = 0.0;
    private double yDistance = 0.0;
    private double zDistance = 0.0;

    protected PotionDotParticle(ClientLevel level, double x, double y, double z, int color, @Nullable Entity entity, SpriteSet sprites) {
        super(level, x, y, z);
        this.entity = entity;
        this.yd = 0.2;
        this.lifetime = Mth.nextInt((RandomSource)this.random, (int)8, (int)12);
        this.pickSprite(sprites);
        this.scale(1.3f);
        this.hasEntity = entity != null;
        this.alpha = ((Float)ModConfigs.ENTITIES.humanoids.potionRingsAlpha.get()).floatValue();
        if (this.hasEntity) {
            this.xDistance = x - entity.getX();
            this.yDistance = y - entity.getY();
            this.zDistance = z - entity.getZ();
        }
        float colorIntensity = 0.3f;
        float whiteIntensity = 1.0f - colorIntensity;
        this.setColor(whiteIntensity + colorIntensity * ((float)FastColor.ARGB32.red((int)color) / 255.0f), whiteIntensity + colorIntensity * ((float)FastColor.ARGB32.green((int)color) / 255.0f), whiteIntensity + colorIntensity * ((float)FastColor.ARGB32.blue((int)color) / 255.0f));
    }

    public void tick() {
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.move(0.0, this.yd, 0.0);
        this.yd *= (double)this.friction;
        if (this.hasEntity) {
            this.yDistance += this.y - this.yo;
            this.setPos(this.entity.getX() + this.xDistance, this.entity.getY() + this.yDistance, this.entity.getZ() + this.zDistance);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void move(double x, double y, double z) {
        if (y != 0.0) {
            this.setBoundingBox(this.getBoundingBox().move(x, y, z));
            this.setLocationFromBoundingbox();
        }
    }

    public record PotionDotProvider(SpriteSet sprites) implements ParticleProvider<ColorAndIntegerParticleOptions>
    {
        public Particle createParticle(ColorAndIntegerParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new PotionDotParticle(level, x, y, z, options.color(), level.getEntity(options.integer()), this.sprites);
        }
    }
}

