/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.particle;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.init.ModSounds;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import einstein.subtle_effects.util.DripParticleAccessor;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.Util;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.DripParticle;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DripParticle.class})
public abstract class DripParticleMixin
extends TextureSheetParticle
implements DripParticleAccessor {
    @Shadow
    protected boolean isGlowing;
    @Shadow
    @Final
    private Fluid type;
    @Unique
    private boolean subtleEffects$dripIntoFluidEffectsPlayed;
    @Unique
    private boolean subtleEffects$isLava;
    @Unique
    private boolean subtleEffects$isSilent = false;

    protected DripParticleMixin(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(ClientLevel level, double x, double y, double z, Fluid fluid, CallbackInfo ci) {
        this.subtleEffects$isLava = this.type.is(FluidTags.LAVA);
        if (ModConfigs.GENERAL.glowingLavaDrops && this.subtleEffects$isLava) {
            this.isGlowing = true;
        }
    }

    @Inject(method={"tick"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/material/Fluids;EMPTY:Lnet/minecraft/world/level/material/Fluid;")})
    private void tick(CallbackInfo ci) {
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        BlockState state = this.level.getBlockState(pos);
        FluidState fluidState = this.level.getFluidState(pos);
        double fluidHeight = Math.max(Util.getCauldronFillHeight(state), (double)fluidState.getHeight((BlockGetter)this.level, pos));
        double fluidSurface = (double)pos.getY() + fluidHeight + 0.01;
        if (fluidHeight > 0.0 && this.y <= fluidSurface) {
            Fluid fluid;
            Fluid fluid2 = fluid = fluidState.isEmpty() ? Util.getCauldronFluid(state) : fluidState.getType();
            if (ModConfigs.GENERAL.fluidDropsEvaporate && (fluid.is(FluidTags.LAVA) && !this.subtleEffects$isLava || fluid.is(FluidTags.WATER) && this.subtleEffects$isLava)) {
                this.level.addParticle((ParticleOptions)ModParticles.STEAM.get(), this.x, fluidSurface, this.z, 0.0, 0.0, 0.0);
                if (((Float)ModConfigs.GENERAL.fluidDropsEvaporationVolume.get()).floatValue() > 0.0f && !this.subtleEffects$isSilent) {
                    this.level.playLocalSound(this.x, this.y, this.z, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, Mth.randomBetween((RandomSource)this.random, (float)0.3f, (float)1.0f) * ((Float)ModConfigs.GENERAL.fluidDropsEvaporationVolume.get()).floatValue(), 2.6f + (this.random.nextFloat() - this.random.nextFloat()) * 0.8f, false);
                }
                this.remove();
                return;
            }
            if (!this.subtleEffects$dripIntoFluidEffectsPlayed) {
                if (((Float)ModConfigs.GENERAL.dropLandSoundVolume.get()).floatValue() > 0.0f && !this.subtleEffects$isSilent) {
                    Supplier<SoundEvent> sound = this.subtleEffects$isLava ? ModSounds.DRIP_LAVA_INTO_FLUID : ModSounds.DRIP_WATER_INTO_FLUID;
                    this.level.playLocalSound(this.x, this.y, this.z, sound.get(), SoundSource.BLOCKS, Mth.randomBetween((RandomSource)this.random, (float)0.3f, (float)1.0f) * ((Float)ModConfigs.GENERAL.dropLandSoundVolume.get()).floatValue(), 1.0f, false);
                }
                if (ModConfigs.GENERAL.dropLandInFluidRipples) {
                    this.level.addParticle((ParticleOptions)new FloatParticleOptions(this.subtleEffects$isLava ? ModParticles.LAVA_RIPPLE.get() : ModParticles.WATER_RIPPLE.get(), Math.max(this.quadSize, Math.max(this.bbWidth, this.bbHeight)) + 0.90000004f), this.x + MathUtil.nextNonAbsDouble(this.random, 0.07), fluidSurface, this.z + MathUtil.nextNonAbsDouble(this.random, 0.07), 0.0, 0.0, 0.0);
                }
                this.subtleEffects$dripIntoFluidEffectsPlayed = true;
            }
        }
    }

    @Override
    public void subtleEffects$setSilent() {
        this.subtleEffects$isSilent = true;
    }

    @Override
    public boolean subtleEffects$isSilent() {
        return this.subtleEffects$isSilent;
    }
}

