/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.entity;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import einstein.subtle_effects.compat.CompatHelper;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AreaEffectCloud.class})
public abstract class AreaEffectCloudMixin {
    @Unique
    private int subtleEffects$waitedTime;
    @Unique
    private final AreaEffectCloud subtleEffects$me = (AreaEffectCloud)this;
    @Shadow
    @Final
    private static EntityDataAccessor<ParticleOptions> DATA_PARTICLE;

    @Shadow
    public abstract boolean isWaiting();

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        if (this.subtleEffects$me.level().isClientSide() && this.isWaiting() && this.subtleEffects$waitedTime < 10) {
            ++this.subtleEffects$waitedTime;
        }
    }

    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addAlwaysVisibleParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V", ordinal=0)})
    private void replaceWaitingParticles(Level level, ParticleOptions options, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Operation<Void> original) {
        if (ModConfigs.ITEMS.lingeringPotionClouds) {
            if (this.subtleEffects$waitedTime < 10) {
                return;
            }
            options = ColorParticleOption.create(ModParticles.POTION_POOF_CLOUD.get(), (int)-1);
        }
        original.call(new Object[]{level, options, x, y, z, xSpeed, ySpeed, zSpeed});
    }

    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addAlwaysVisibleParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V", ordinal=1)})
    private void replaceEffectParticles(Level level, ParticleOptions options, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Operation<Void> original) {
        ColorParticleOption colorOptions;
        if (ModConfigs.ITEMS.lingeringPotionClouds && this.subtleEffects$spawnParticles(level, (colorOptions = (ColorParticleOption)options).getRed(), colorOptions.getGreen(), colorOptions.getBlue(), x, y, z, 20, 4)) {
            return;
        }
        original.call(new Object[]{level, options, x, y, z, xSpeed, ySpeed, zSpeed});
    }

    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addAlwaysVisibleParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V", ordinal=2)})
    private void replaceNonEffectWaitingParticles(Level level, ParticleOptions options, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Operation<Void> original) {
        if (ModConfigs.ITEMS.lingeringPotionClouds && CompatHelper.IS_PARTICLE_EFFECTS_LOADED.get().booleanValue()) {
            if (this.subtleEffects$waitedTime < 10) {
                return;
            }
            if (this.subtleEffects$me.getRandom().nextBoolean() && AreaEffectCloudMixin.subtleEffects$isParticleEffectsParticle(options)) {
                options = ColorParticleOption.create(ModParticles.POTION_POOF_CLOUD.get(), (int)-1);
            }
        }
        original.call(new Object[]{level, options, x, y, z, xSpeed, ySpeed, zSpeed});
    }

    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addAlwaysVisibleParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V", ordinal=3)})
    private void replaceNonEffectParticles(Level level, ParticleOptions options, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Operation<Void> original) {
        ColorParticleOption colorOption;
        ParticleOptions particleOptions;
        RandomSource random;
        if (ModConfigs.ENTITIES.dragonsBreathClouds && options.getType() == ParticleTypes.DRAGON_BREATH && this.subtleEffects$spawnParticles(level, Mth.nextFloat((RandomSource)(random = this.subtleEffects$me.getRandom()), (float)0.7176471f, (float)0.8745098f), 0.0f, Mth.nextFloat((RandomSource)random, (float)0.8235294f, (float)0.9764706f), x, y, z, 35, 15)) {
            return;
        }
        if (ModConfigs.ITEMS.lingeringPotionClouds && CompatHelper.IS_PARTICLE_EFFECTS_LOADED.get().booleanValue() && AreaEffectCloudMixin.subtleEffects$isParticleEffectsParticle(options) && (particleOptions = (ParticleOptions)this.subtleEffects$me.getEntityData().get(DATA_PARTICLE)) instanceof ColorParticleOption && this.subtleEffects$spawnParticles(level, (colorOption = (ColorParticleOption)particleOptions).getRed(), colorOption.getGreen(), colorOption.getBlue(), x, y, z, 20, 24)) {
            return;
        }
        original.call(new Object[]{level, options, x, y, z, xSpeed, ySpeed, zSpeed});
    }

    @Unique
    private boolean subtleEffects$spawnParticles(Level level, float red, float green, float blue, double x, double y, double z, int density, int waitingDensity) {
        boolean isWaiting = this.isWaiting();
        if (isWaiting && this.subtleEffects$waitedTime < 10) {
            return true;
        }
        RandomSource random = this.subtleEffects$me.getRandom();
        if (random.nextInt(isWaiting ? waitingDensity : density) == 0) {
            if (isWaiting) {
                level.addParticle((ParticleOptions)ColorParticleOption.create(ModParticles.POTION_POOF_CLOUD.get(), (float)red, (float)green, (float)blue), x, y, z, 0.0, 0.0, 0.0);
            } else {
                if (this.subtleEffects$me.tickCount <= 5) {
                    return true;
                }
                level.addAlwaysVisibleParticle((ParticleOptions)ColorParticleOption.create(ModParticles.POTION_CLOUD.get(), (float)red, (float)green, (float)blue), x, this.subtleEffects$me.getY() + random.nextDouble() / 10.0, z, 0.0, 0.0, 0.0);
            }
        }
        return !isWaiting && random.nextInt(20) > 0;
    }

    @Unique
    private static boolean subtleEffects$isParticleEffectsParticle(ParticleOptions options) {
        ResourceLocation id = BuiltInRegistries.PARTICLE_TYPE.getKey((Object)options.getType());
        return id != null && id.getNamespace().equals("particle-effects");
    }
}

