/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.kinetics.grindstone;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.deployer.ItemApplicationRecipe;
import com.simibubi.create.content.kinetics.deployer.ManualApplicationRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createenchantmentindustry.common.CEICommon;
import plus.dragons.createenchantmentindustry.common.registry.CEIBlocks;

public class MechanicalGrindStoneItem
extends BlockItem {
    public MechanicalGrindStoneItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static RecipeHolder<ManualApplicationRecipe> createRecipe() {
        return new RecipeHolder(CEICommon.asResource("mechanical_grindstone"), (Recipe)((ManualApplicationRecipe)((ItemApplicationRecipe.Builder)((ItemApplicationRecipe.Builder)((ItemApplicationRecipe.Builder)new ItemApplicationRecipe.Builder(ManualApplicationRecipe::new, CEIBlocks.GRINDSTONE_DRAIN.getId()).require((ItemLike)AllBlocks.ITEM_DRAIN)).require(CEIBlocks.MECHANICAL_GRINDSTONE)).output(CEIBlocks.GRINDSTONE_DRAIN)).build()));
    }

    public InteractionResult useOn(UseOnContext context) {
        return this.place(new PlaceContext(context));
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        if (context instanceof PlaceContext) {
            PlaceContext placeContext = (PlaceContext)context;
            return placeContext.getPlacementState();
        }
        return super.getPlacementState(context);
    }

    public class PlaceContext
    extends BlockPlaceContext {
        private final boolean clickedDrain;

        public PlaceContext(UseOnContext context) {
            super(context);
            BlockPos clickedPos = context.getClickedPos();
            BlockState clickedState = context.getLevel().getBlockState(clickedPos);
            this.clickedDrain = clickedState.is((Holder)AllBlocks.ITEM_DRAIN);
            this.replaceClicked |= this.clickedDrain;
        }

        @Nullable
        public BlockState getPlacementState() {
            if (this.clickedDrain) {
                Direction facing = this.getHorizontalDirection().getOpposite();
                return (BlockState)CEIBlocks.GRINDSTONE_DRAIN.getDefaultState().setValue(HorizontalKineticBlock.HORIZONTAL_FACING, (Comparable)facing);
            }
            return MechanicalGrindStoneItem.super.getPlacementState(this);
        }
    }
}

