/*
 * Decompiled with CFR 0.152.
 */
package net.dypiduo.easyfilling.compat.createsa;

import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class LargeTankStockHandler
implements IFluidHandlerItem {
    private static final String KEY = "tagStock";
    private final ItemStack container;
    private final boolean isWaterTank;
    private final int capacity;

    public LargeTankStockHandler(ItemStack container, boolean isWaterTank, int capacity) {
        this.container = container;
        this.isWaterTank = isWaterTank;
        this.capacity = capacity;
    }

    private int cap() {
        return this.capacity;
    }

    private int getAmount() {
        CustomData cd = (CustomData)this.container.get(DataComponents.CUSTOM_DATA);
        if (cd == null) {
            return 0;
        }
        CompoundTag t = cd.copyTag();
        return t.getInt(KEY);
    }

    private void setAmount(int v) {
        int clamped = Mth.clamp((int)v, (int)0, (int)this.cap());
        CustomData cd = (CustomData)this.container.get(DataComponents.CUSTOM_DATA);
        CompoundTag t = cd != null ? cd.copyTag() : new CompoundTag();
        t.putInt(KEY, clamped);
        this.container.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)t));
    }

    public ItemStack getContainer() {
        return this.container;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        int amt = this.getAmount();
        if (amt <= 0) {
            return FluidStack.EMPTY;
        }
        return new FluidStack((Fluid)(this.isWaterTank ? Fluids.WATER : Fluids.LAVA), amt);
    }

    public int getTankCapacity(int tank) {
        return this.cap();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.isWaterTank ? stack.getFluid() == Fluids.WATER : stack.getFluid() == Fluids.LAVA;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(0, resource)) {
            return 0;
        }
        int cur = this.getAmount();
        int space = Math.max(0, this.cap() - cur);
        int to = Math.min(space, resource.getAmount());
        if (to > 0 && action.execute()) {
            this.setAmount(cur + to);
        }
        return to;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(0, resource)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain <= 0) {
            return FluidStack.EMPTY;
        }
        int cur = this.getAmount();
        int take = Math.min(cur, maxDrain);
        if (take <= 0) {
            return FluidStack.EMPTY;
        }
        if (action.execute()) {
            this.setAmount(cur - take);
        }
        return new FluidStack((Fluid)(this.isWaterTank ? Fluids.WATER : Fluids.LAVA), take);
    }
}

