/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.flerovium.mixins.Block;

import com.moepus.flerovium.functions.BlockBreaking.BlockBreakingDecalGenerator;
import com.moepus.flerovium.functions.BlockBreaking.BlockBreakingRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.SortedSet;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={LevelRenderer.class}, remap=false)
public abstract class CrumblingRendererMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Nullable
    private ClientLevel level;
    @Shadow
    @Final
    private RenderBuffers renderBuffers;

    @Shadow
    public abstract Frustum getFrustum();

    @Redirect(method={"renderLevel"}, at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;long2ObjectEntrySet()Lit/unimi/dsi/fastutil/objects/ObjectSet;"))
    private ObjectSet<Long2ObjectMap.Entry<SortedSet<BlockDestructionProgress>>> fasterBlockBreakingRendering(Long2ObjectMap<SortedSet<BlockDestructionProgress>> instance, DeltaTracker deltaTracker, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f frustumMatrix, Matrix4f projectionMatrix) {
        Vec3 camPos = camera.getPosition();
        ObjectSet set = instance.long2ObjectEntrySet();
        PoseStack poseStack = new PoseStack();
        for (Long2ObjectMap.Entry entry : set) {
            float relz;
            float rely;
            BlockPos pos = BlockPos.of((long)entry.getLongKey());
            Frustum frustum = this.getFrustum();
            float relx = (float)pos.getX() - (float)camPos.x;
            if (!frustum.intersection.testSphere(relx, rely = (float)pos.getY() - (float)camPos.y, relz = (float)pos.getZ() - (float)camPos.z, 0.7f)) continue;
            int k = ((BlockDestructionProgress)((SortedSet)entry.getValue()).last()).getProgress();
            VertexConsumer consumer = this.renderBuffers.crumblingBufferSource().getBuffer((RenderType)ModelBakery.DESTROY_TYPES.get(k));
            poseStack.pushPose();
            poseStack.translate(relx, rely, relz);
            BlockBreakingDecalGenerator decal = new BlockBreakingDecalGenerator(consumer, relx, rely, relz);
            ModelData modelData = this.level.getModelData(pos);
            BlockBreakingRenderer.renderBreakingTexture(this.minecraft.getBlockRenderer(), camPos, this.level.getBlockState(pos), pos, (BlockAndTintGetter)this.level, poseStack, decal, modelData);
            poseStack.popPose();
        }
        return ObjectSet.of();
    }
}

