/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.flerovium.functions.BlockBreaking;

import com.moepus.flerovium.functions.BlockBreaking.WrappedModel;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;

public class BlockBreakingRenderer {
    private static final RandomSource random = RandomSource.createNewThreadLocalInstance();

    private static int calcVisibleFaces(Vec3 camPos, int blockX, int blockY, int blockZ) {
        if (RenderSystem.modelViewMatrix.m32() != 0.0f) {
            return 63;
        }
        int faces = 0;
        double cx = camPos.x - ((double)blockX + 0.5);
        double cy = camPos.y - ((double)blockY + 0.5);
        double cz = camPos.z - ((double)blockZ + 0.5);
        for (Direction dir : Direction.values()) {
            int nz;
            int ny;
            int nx = dir.getStepX();
            double dot = (double)nx * cx + (double)(ny = dir.getStepY()) * cy + (double)(nz = dir.getStepZ()) * cz;
            if (!(dot > 0.0)) continue;
            faces |= 1 << dir.ordinal();
        }
        return faces;
    }

    public static void renderBreakingTexture(BlockRenderDispatcher blockRenderDispatcher, Vec3 camPos, BlockState state, BlockPos pos, BlockAndTintGetter level, PoseStack poseStack, VertexConsumer consumer, ModelData modelData) {
        if (state.getRenderShape() == RenderShape.MODEL) {
            BakedModel bakedmodel = blockRenderDispatcher.getBlockModelShaper().getBlockModel(state);
            WrappedModel wrappedModel = new WrappedModel(bakedmodel, BlockBreakingRenderer.calcVisibleFaces(camPos, pos.getX(), pos.getY(), pos.getZ()));
            long i = state.getSeed(pos);
            modelData = bakedmodel.getModelData(level, pos, state, modelData);
            blockRenderDispatcher.getModelRenderer().tesselateBlock(level, (BakedModel)wrappedModel, state, pos, poseStack, consumer, true, random, i, OverlayTexture.NO_OVERLAY, modelData, null);
        }
    }
}

