/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.flerovium.functions.BlockBreaking;

import com.moepus.flerovium.Iris.IrisTerrainVertex;
import com.moepus.flerovium.functions.BlockBreaking.BlockVertex;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.caffeinemc.mods.sodium.api.math.MatrixHelper;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.client.model.quad.ModelQuadView;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryStack;

public class BlockBreakingDecalGenerator
implements VertexConsumer {
    private final VertexConsumer delegate;
    private final float relX;
    private final float relY;
    private final float relZ;
    private float x;
    private float y;
    private float z;

    public BlockBreakingDecalGenerator(VertexConsumer delegate, float relX, float blockY, float blockZ) {
        this.delegate = delegate;
        this.relX = relX;
        this.relY = blockY;
        this.relZ = blockZ;
    }

    public VertexConsumer addVertex(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.delegate.addVertex(x, y, z);
        return this;
    }

    public VertexConsumer setColor(int red, int green, int blue, int alpha) {
        this.delegate.setColor(-1);
        return this;
    }

    public VertexConsumer setUv(float u, float v) {
        return this;
    }

    public VertexConsumer setUv1(int u, int v) {
        this.delegate.setUv1(u, v);
        return this;
    }

    public VertexConsumer setUv2(int u, int v) {
        this.delegate.setUv2(u, v);
        return this;
    }

    private static Vector3f calcUV(float normalX, float normalY, float normalZ, float dx, float dy, float dz) {
        float u;
        Direction direction = Direction.getNearest((float)normalX, (float)normalY, (float)normalZ);
        return new Vector3f(u, switch (direction) {
            case Direction.DOWN -> {
                u = dx;
                yield -dz;
            }
            case Direction.UP -> {
                u = dx;
                yield dz;
            }
            case Direction.NORTH -> {
                u = -dx;
                yield -dy;
            }
            case Direction.SOUTH -> {
                u = dx;
                yield -dy;
            }
            case Direction.WEST -> {
                u = dz;
                yield -dy;
            }
            case Direction.EAST -> {
                u = -dz;
                yield -dy;
            }
            default -> {
                u = 0.0f;
                yield 0.0f;
            }
        }, 0.0f);
    }

    public VertexConsumer setNormal(float normalX, float normalY, float normalZ) {
        this.delegate.setNormal(normalX, normalY, normalZ);
        float dx = this.x - this.relX;
        float dy = this.y - this.relY;
        float dz = this.z - this.relZ;
        Vector3f uv = BlockBreakingDecalGenerator.calcUV(normalX, normalY, normalZ, dx, dy, dz);
        this.delegate.setUv(uv.x, uv.y);
        return this;
    }

    void putBulkDataSodium(VertexBufferWriter writer, PoseStack.Pose pose, BakedQuad bakedQuad, int[] lightmap) {
        ModelQuadView quad = (ModelQuadView)bakedQuad;
        Matrix3f matNormal = pose.normal();
        Matrix4f matPosition = pose.pose();
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(128);
            for (int i = 0; i < 4; ++i) {
                float x = quad.getX(i);
                float y = quad.getY(i);
                float z = quad.getZ(i);
                int bakedLight = quad.getLight(i);
                int light = lightmap[i];
                int newLight = Math.max((int)((bakedLight & 0xFFFF) << 16 | bakedLight >> 16), (int)light);
                int normal = MatrixHelper.transformNormal((Matrix3f)matNormal, (boolean)false, (int)quad.getAccurateNormal(i));
                float nx = NormI8.unpackX((int)normal);
                float ny = NormI8.unpackY((int)normal);
                float nz = NormI8.unpackZ((int)normal);
                Vector3f uv = BlockBreakingDecalGenerator.calcUV(nx, ny, nz, x, y, z);
                float xt = MatrixHelper.transformPositionX((Matrix4f)matPosition, (float)x, (float)y, (float)z);
                float yt = MatrixHelper.transformPositionY((Matrix4f)matPosition, (float)x, (float)y, (float)z);
                float zt = MatrixHelper.transformPositionZ((Matrix4f)matPosition, (float)x, (float)y, (float)z);
                BlockVertex.write(ptr, xt, yt, zt, -1, Float.floatToIntBits(uv.x), Float.floatToIntBits(uv.y), newLight, normal);
                ptr += 32L;
            }
            writer.push(stack, buffer, 4, BlockVertex.FORMAT);
        }
    }

    void putBulkDataIris(VertexBufferWriter writer, PoseStack.Pose pose, BakedQuad bakedQuad, int[] lightmap) {
        ModelQuadView quad = (ModelQuadView)bakedQuad;
        Matrix3f matNormal = pose.normal();
        Matrix4f matPosition = pose.pose();
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(208);
            for (int i = 0; i < 4; ++i) {
                float x = quad.getX(i);
                float y = quad.getY(i);
                float z = quad.getZ(i);
                int bakedLight = quad.getLight(i);
                int light = lightmap[i];
                int newLight = Math.max((int)((bakedLight & 0xFFFF) << 16 | bakedLight >> 16), (int)light);
                int normal = MatrixHelper.transformNormal((Matrix3f)matNormal, (boolean)false, (int)quad.getAccurateNormal(i));
                float nx = NormI8.unpackX((int)normal);
                float ny = NormI8.unpackY((int)normal);
                float nz = NormI8.unpackZ((int)normal);
                Vector3f uv = BlockBreakingDecalGenerator.calcUV(nx, ny, nz, x, y, z);
                float xt = MatrixHelper.transformPositionX((Matrix4f)matPosition, (float)x, (float)y, (float)z);
                float yt = MatrixHelper.transformPositionY((Matrix4f)matPosition, (float)x, (float)y, (float)z);
                float zt = MatrixHelper.transformPositionZ((Matrix4f)matPosition, (float)x, (float)y, (float)z);
                IrisTerrainVertex.write(ptr, xt, yt, zt, -1, uv.x, uv.y, 0.0f, 0.0f, newLight, normal, -1);
                ptr += 52L;
            }
            writer.push(stack, buffer, 4, IrisTerrainVertex.FORMAT);
        }
    }

    public void putBulkData(PoseStack.Pose pose, BakedQuad bakedQuad, float[] brightness, float red, float green, float blue, float alpha, int[] lightmap, int packedOverlay, boolean readAlpha) {
        if (bakedQuad.getVertices().length < 32) {
            return;
        }
        VertexBufferWriter writer = VertexBufferWriter.tryOf((VertexConsumer)this.delegate);
        if (writer == null) {
            super.putBulkData(pose, bakedQuad, brightness, (float)FastColor.ARGB32.red((int)-1), (float)FastColor.ARGB32.green((int)-1), (float)FastColor.ARGB32.blue((int)-1), (float)FastColor.ARGB32.alpha((int)-1), lightmap, packedOverlay, readAlpha);
            return;
        }
        VertexConsumer vertexConsumer = this.delegate;
        if (!(vertexConsumer instanceof BufferBuilder)) {
            return;
        }
        BufferBuilder bb = (BufferBuilder)vertexConsumer;
        if (bb.format == BlockVertex.FORMAT) {
            this.putBulkDataSodium(writer, pose, bakedQuad, lightmap);
        } else {
            this.putBulkDataIris(writer, pose, bakedQuad, lightmap);
        }
    }
}

