/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.nbt;

import com.teamresourceful.resourcefullib.common.nbt.NbtReader;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class TagReader<I, T extends Tag>
implements NbtReader<I, T> {
    private final byte type;
    private final Function<I, T> writer;
    private final BiConsumer<I, T> reader;
    @Nullable
    private final Supplier<T> defaultCreator;

    public TagReader(byte type, Function<I, T> writer, BiConsumer<I, T> reader, @Nullable Supplier<T> defaultCreator) {
        this.type = type;
        this.writer = writer;
        this.reader = reader;
        this.defaultCreator = defaultCreator;
    }

    public static <I> TagReader<I, ByteTag> byteTag(Function<I, Byte> writer, BiConsumer<I, Byte> reader) {
        return new TagReader<Object, ByteTag>(1, i -> ByteTag.valueOf((byte)((Byte)writer.apply(i))), (i, t) -> reader.accept(i, t.getAsByte()), null);
    }

    public static <I> TagReader<I, ByteTag> byteTag(Function<I, Byte> writer, BiConsumer<I, Byte> reader, byte defaultValue) {
        return new TagReader<Object, ByteTag>(1, i -> ByteTag.valueOf((byte)((Byte)writer.apply(i))), (i, t) -> reader.accept(i, t.getAsByte()), () -> ByteTag.valueOf((byte)defaultValue));
    }

    public static <I> TagReader<I, ShortTag> shortTag(Function<I, Short> writer, BiConsumer<I, Short> reader) {
        return new TagReader<Object, ShortTag>(2, i -> ShortTag.valueOf((short)((Short)writer.apply(i))), (i, t) -> reader.accept(i, t.getAsShort()), null);
    }

    public static <I> TagReader<I, ShortTag> shortTag(Function<I, Short> writer, BiConsumer<I, Short> reader, short defaultValue) {
        return new TagReader<Object, ShortTag>(2, i -> ShortTag.valueOf((short)((Short)writer.apply(i))), (i, t) -> reader.accept(i, t.getAsShort()), () -> ShortTag.valueOf((short)defaultValue));
    }

    public static <I> TagReader<I, IntTag> intTag(Function<I, Integer> writer, BiConsumer<I, Integer> reader) {
        return new TagReader<Object, IntTag>(3, i -> IntTag.valueOf((int)((Integer)writer.apply(i))), (i, t) -> reader.accept(i, t.getAsInt()), null);
    }

    public static <I> TagReader<I, IntTag> intTag(Function<I, Integer> writer, BiConsumer<I, Integer> reader, int defaultValue) {
        return new TagReader<Object, IntTag>(3, i -> IntTag.valueOf((int)((Integer)writer.apply(i))), (i, t) -> reader.accept(i, t.getAsInt()), () -> IntTag.valueOf((int)defaultValue));
    }

    public static <I> TagReader<I, LongTag> longTag(Function<I, Long> writer, BiConsumer<I, Long> reader) {
        return new TagReader<Object, LongTag>(4, i -> LongTag.valueOf((long)((Long)writer.apply(i))), (i, t) -> reader.accept(i, t.getAsLong()), null);
    }

    public static <I> TagReader<I, LongTag> longTag(Function<I, Long> writer, BiConsumer<I, Long> reader, long defaultValue) {
        return new TagReader<Object, LongTag>(4, i -> LongTag.valueOf((long)((Long)writer.apply(i))), (i, t) -> reader.accept(i, t.getAsLong()), () -> LongTag.valueOf((long)defaultValue));
    }

    public static <I> TagReader<I, FloatTag> floatTag(Function<I, Float> writer, BiConsumer<I, Float> reader) {
        return new TagReader<Object, FloatTag>(5, i -> FloatTag.valueOf((float)((Float)writer.apply(i)).floatValue()), (i, t) -> reader.accept(i, Float.valueOf(t.getAsFloat())), null);
    }

    public static <I> TagReader<I, FloatTag> floatTag(Function<I, Float> writer, BiConsumer<I, Float> reader, float defaultValue) {
        return new TagReader<Object, FloatTag>(5, i -> FloatTag.valueOf((float)((Float)writer.apply(i)).floatValue()), (i, t) -> reader.accept(i, Float.valueOf(t.getAsFloat())), () -> FloatTag.valueOf((float)defaultValue));
    }

    public static <I> TagReader<I, DoubleTag> doubleTag(Function<I, Double> writer, BiConsumer<I, Double> reader) {
        return new TagReader<Object, DoubleTag>(6, i -> DoubleTag.valueOf((double)((Double)writer.apply(i))), (i, t) -> reader.accept(i, t.getAsDouble()), null);
    }

    public static <I> TagReader<I, DoubleTag> doubleTag(Function<I, Double> writer, BiConsumer<I, Double> reader, double defaultValue) {
        return new TagReader<Object, DoubleTag>(6, i -> DoubleTag.valueOf((double)((Double)writer.apply(i))), (i, t) -> reader.accept(i, t.getAsDouble()), () -> DoubleTag.valueOf((double)defaultValue));
    }

    public static <I> TagReader<I, StringTag> stringTag(Function<I, String> writer, BiConsumer<I, String> reader) {
        return new TagReader<Object, StringTag>(8, i -> StringTag.valueOf((String)((String)writer.apply(i))), (i, t) -> reader.accept(i, t.getAsString()), null);
    }

    public static <I> TagReader<I, StringTag> stringTag(Function<I, String> writer, BiConsumer<I, String> reader, String defaultValue) {
        return new TagReader<Object, StringTag>(8, i -> StringTag.valueOf((String)((String)writer.apply(i))), (i, t) -> reader.accept(i, t.getAsString()), () -> StringTag.valueOf((String)defaultValue));
    }

    @Override
    public byte type() {
        return this.type;
    }

    @Override
    public void setDefault(I instance) {
        if (this.defaultCreator != null) {
            this.reader.accept(instance, (Tag)this.defaultCreator.get());
        }
    }

    @Override
    public void read(I instance, T tag) {
        this.reader.accept(instance, tag);
    }

    @Override
    public T write(I instance) {
        return (T)((Tag)this.writer.apply(instance));
    }
}

