/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ControllerData
extends BlockEntityDataShim {
    private BlockPos controllerCoord;
    private boolean needsValidation;

    @Override
    public void read(HolderLookup.Provider provider, CompoundTag tag) {
        this.controllerCoord = null;
        if (tag.contains("Controller", 10)) {
            CompoundTag ctag = tag.getCompound("Controller");
            this.controllerCoord = new BlockPos(ctag.getInt("x"), ctag.getInt("y"), ctag.getInt("z"));
        }
        this.needsValidation = false;
        if (tag.contains("Validate")) {
            this.needsValidation = tag.getBoolean("Validate");
        }
    }

    @Override
    public CompoundTag write(HolderLookup.Provider provider, CompoundTag tag) {
        if (this.controllerCoord != null) {
            CompoundTag ctag = new CompoundTag();
            ctag.putInt("x", this.controllerCoord.getX());
            ctag.putInt("y", this.controllerCoord.getY());
            ctag.putInt("z", this.controllerCoord.getZ());
            tag.put("Controller", (Tag)ctag);
        }
        if (this.needsValidation) {
            tag.putBoolean("Validate", this.needsValidation);
        }
        return tag;
    }

    public BlockPos getCoord() {
        return this.controllerCoord;
    }

    public BlockEntityController getController(BlockEntity host) {
        if (this.controllerCoord == null) {
            return null;
        }
        if (host.getLevel() == null) {
            return null;
        }
        BlockEntity blockEntity = host.getLevel().getBlockEntity(this.controllerCoord);
        if (!(blockEntity instanceof BlockEntityController)) {
            this.controllerCoord = null;
            host.setChanged();
            return null;
        }
        return (BlockEntityController)blockEntity;
    }

    public boolean bind(BlockEntityController entity) {
        return this.bindCoord(entity != null ? entity.getBlockPos() : null);
    }

    public boolean bindCoord(BlockPos pos) {
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("ControllerData [{}] bind coord [{}]", (Object)this.controllerCoord, (Object)pos);
        }
        if (this.controllerCoord == null || !this.controllerCoord.equals((Object)pos)) {
            this.controllerCoord = pos;
            return true;
        }
        return false;
    }

    public boolean needsValidation() {
        return this.needsValidation;
    }

    public void setNeedsValidation(boolean state) {
        this.needsValidation = state;
    }
}

