/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.highlighter.config;

import com.anthonyhilyard.iceberg.config.IcebergConfig;
import com.anthonyhilyard.iceberg.services.IIcebergConfigSpecBuilder;
import com.anthonyhilyard.iceberg.util.ItemColor;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class HighlighterConfig
extends IcebergConfig<HighlighterConfig> {
    public final Supplier<Boolean> clearOnInventoryClose;
    public final Supplier<Boolean> clearOnHover;
    public final Supplier<Boolean> clearOnSelect;
    public final Supplier<Boolean> useItemNameColor;
    public final Supplier<Boolean> showOnHotbar;
    public final Supplier<IconPosition> iconPosition;
    private static Map<Pair<Item, DataComponentMap>, TextColor> colorCache = Maps.newHashMap();

    public static HighlighterConfig getInstance() {
        return (HighlighterConfig)((Object)configInstances.get("highlighter"));
    }

    public HighlighterConfig(IIcebergConfigSpecBuilder build) {
        build.comment("Client Configuration").push("client").push("options");
        this.clearOnInventoryClose = build.comment(" If new item markers should be cleared when the inventory is closed.").add("clear_on_close", true);
        this.clearOnHover = build.comment(" If new item markers should be cleared when the item tooltip is displayed.").add("clear_on_hover", true);
        this.clearOnSelect = build.comment(" If new item markers should be cleared when the item is selected on the hotbar.").add("clear_on_select", true);
        this.useItemNameColor = build.comment(" If icons should match the color of items names (as shown in tooltips).  Otherwise icons will all be gold.").add("item_name_color", false);
        this.showOnHotbar = build.comment(" If new item markers should show on the hotbar.").add("show_on_hotbar", true);
        this.iconPosition = build.comment(" The position of new item markers.").addEnum("icon_position", (Enum)IconPosition.UpperLeft);
        build.pop().pop();
    }

    public static TextColor getColorForItem(ItemStack itemStack, TextColor defaultColor) {
        Pair key = Pair.of((Object)itemStack.getItem(), (Object)new PatchedDataComponentMap(itemStack.getComponents()));
        if (!colorCache.containsKey(key)) {
            TextColor color = ItemColor.getColorForItem((ItemStack)itemStack, (TextColor)defaultColor);
            colorCache.put((Pair<Item, DataComponentMap>)key, color);
        }
        return colorCache.get(key);
    }

    protected void onReload() {
        colorCache.clear();
    }

    public static enum IconPosition {
        UpperLeft,
        UpperRight,
        LowerLeft,
        LowerRight;

    }
}

