/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.mixin.logistics.packager;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packagerLink.RequestPromise;
import com.simibubi.create.content.logistics.packagerLink.RequestPromiseQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericKey;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_abstractions.generic.impl.GenericContentExtender;
import ru.zznty.create_factory_abstractions.generic.stack.GenericStackSerializer;
import ru.zznty.create_factory_abstractions.generic.support.BigGenericStack;
import ru.zznty.create_factory_abstractions.generic.support.GenericPromiseQueue;

@Mixin(value={RequestPromiseQueue.class})
public class GenericPromiseQueueMixin
implements GenericPromiseQueue {
    @Unique
    private final Multimap<GenericKey, RequestPromise> createFactoryLogistics$promises = HashMultimap.create();
    @Shadow
    private Runnable onChanged;

    @Overwrite
    public void forceClear(ItemStack stack) {
        this.forceClear(GenericStack.wrap((ItemStack)stack));
    }

    @Overwrite
    public int getTotalPromisedAndRemoveExpired(ItemStack stack, int expiryTime) {
        return this.getTotalPromisedAndRemoveExpired(GenericStack.wrap((ItemStack)stack), expiryTime);
    }

    @Overwrite
    public void itemEnteredSystem(ItemStack stack, int amount) {
        this.stackEnteredSystem(GenericStack.wrap((ItemStack)stack).withAmount(amount));
    }

    public void add(GenericStack stack) {
        this.add(new RequestPromise(BigGenericStack.of((GenericStack)stack).asStack()));
    }

    public void forceClear(GenericStack stack) {
        Collection promises = this.createFactoryLogistics$promises.get((Object)GenericContentExtender.registrationOf((GenericKey)stack.key()).provider().wrapGeneric((Object)stack.key()));
        if (promises.isEmpty()) {
            return;
        }
        Iterator iterator = promises.iterator();
        while (iterator.hasNext()) {
            RequestPromise promise = (RequestPromise)iterator.next();
            BigGenericStack promisedStack = BigGenericStack.of((BigItemStack)promise.promisedStack);
            if (!stack.canStack(promisedStack.get())) continue;
            iterator.remove();
            this.onChanged.run();
        }
    }

    public int getTotalPromisedAndRemoveExpired(GenericStack stack, int expiryTime) {
        int promised = 0;
        Collection promises = this.createFactoryLogistics$promises.get((Object)GenericContentExtender.registrationOf((GenericKey)stack.key()).provider().wrapGeneric((Object)stack.key()));
        if (promises.isEmpty()) {
            return promised;
        }
        Iterator iterator = promises.iterator();
        while (iterator.hasNext()) {
            RequestPromise promise = (RequestPromise)iterator.next();
            BigGenericStack promisedStack = BigGenericStack.of((BigItemStack)promise.promisedStack);
            if (!stack.canStack(promisedStack.get())) continue;
            if (expiryTime != -1 && promise.ticksExisted >= expiryTime) {
                iterator.remove();
                this.onChanged.run();
                continue;
            }
            promised += promise.promisedStack.count;
        }
        return promised;
    }

    public void stackEnteredSystem(GenericStack stack) {
        Collection promises = this.createFactoryLogistics$promises.get((Object)GenericContentExtender.registrationOf((GenericKey)stack.key()).provider().wrapGeneric((Object)stack.key()));
        if (promises.isEmpty()) {
            return;
        }
        int amount = stack.amount();
        Iterator iterator = promises.iterator();
        while (iterator.hasNext()) {
            RequestPromise requestPromise = (RequestPromise)iterator.next();
            BigGenericStack promisedStack = BigGenericStack.of((BigItemStack)requestPromise.promisedStack);
            if (!stack.canStack(promisedStack.get())) continue;
            int toSubtract = Math.min(amount, promisedStack.get().amount());
            amount -= toSubtract;
            promisedStack.setAmount(promisedStack.get().amount() - toSubtract);
            if (promisedStack.get().amount() <= 0) {
                iterator.remove();
                this.onChanged.run();
            }
            if (amount > 0) continue;
            break;
        }
    }

    @Overwrite
    public void add(RequestPromise promise) {
        BigGenericStack promisedStack = BigGenericStack.of((BigItemStack)promise.promisedStack);
        this.createFactoryLogistics$promises.put((Object)GenericContentExtender.registrationOf((GenericKey)promisedStack.get().key()).provider().wrapGeneric((Object)promisedStack.get().key()), (Object)promise);
        if (!promisedStack.get().isEmpty()) {
            this.onChanged.run();
        }
    }

    @Overwrite
    public void tick() {
        this.createFactoryLogistics$promises.forEach((key, promise) -> promise.tick());
    }

    @Overwrite
    public boolean isEmpty() {
        return this.createFactoryLogistics$promises.isEmpty();
    }

    @Overwrite
    public List<RequestPromise> flatten(boolean sorted) {
        ArrayList<RequestPromise> all = new ArrayList<RequestPromise>(this.createFactoryLogistics$promises.values());
        if (sorted) {
            all.sort(RequestPromise.ageComparator());
        }
        return all;
    }

    @Overwrite
    public static RequestPromiseQueue read(CompoundTag tag, HolderLookup.Provider registries, Runnable onChanged) {
        RequestPromiseQueue queue = new RequestPromiseQueue(onChanged);
        ListTag listTag = tag.getList("List", 10);
        NBTHelper.iterateCompoundList((ListTag)listTag, compoundTag -> {
            GenericStack stack = GenericStackSerializer.read((HolderLookup.Provider)registries, (CompoundTag)compoundTag.getCompound("promised_stack"));
            queue.add(new RequestPromise(compoundTag.getInt("ticks_existed"), BigGenericStack.of((GenericStack)stack).asStack()));
        });
        return queue;
    }

    @Overwrite
    public CompoundTag write(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        tag.put("List", (Tag)NBTHelper.writeCompoundList((Iterable)this.createFactoryLogistics$promises.values(), promise -> {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putInt("ticks_existed", promise.ticksExisted);
            CompoundTag stackTag = new CompoundTag();
            GenericStackSerializer.write((HolderLookup.Provider)registries, (GenericStack)BigGenericStack.of((BigItemStack)promise.promisedStack).get(), (CompoundTag)stackTag);
            compoundTag.put("promised_stack", (Tag)stackTag);
            return compoundTag;
        }));
        return tag;
    }
}

