/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.panel.request;

import com.simibubi.create.content.logistics.redstoneRequester.RedstoneRequesterBlockEntity;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_abstractions.generic.stack.GenericStackSerializer;
import ru.zznty.create_factory_abstractions.generic.support.GenericOrder;
import ru.zznty.create_factory_abstractions.generic.support.GenericRedstoneRequester;
import ru.zznty.create_factory_abstractions.generic.support.GenericRedstoneRequesterConfigurationPacket;
import ru.zznty.create_factory_logistics.FactoryPackets;

public class RedstoneRequesterConfigurationPacket
extends BlockEntityConfigurationPacket<RedstoneRequesterBlockEntity>
implements GenericRedstoneRequesterConfigurationPacket {
    private final String address;
    private final boolean allowPartial;
    private final List<GenericStack> stacks;

    public RedstoneRequesterConfigurationPacket(BlockPos pos, String address, boolean allowPartial, List<GenericStack> stacks) {
        super(pos);
        this.address = address;
        this.allowPartial = allowPartial;
        this.stacks = stacks;
    }

    public RedstoneRequesterConfigurationPacket(BlockPos pos, String address, boolean allowPartial) {
        this(pos, address, allowPartial, new ArrayList<GenericStack>());
    }

    protected void applySettings(ServerPlayer player, RedstoneRequesterBlockEntity be) {
        be.encodedTargetAdress = this.address;
        be.allowPartialRequests = this.allowPartial;
        GenericRedstoneRequester requester = (GenericRedstoneRequester)be;
        requester.setOrder(GenericOrder.order(this.stacks));
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return FactoryPackets.CONFIGURE_REDSTONE_REQUESTER;
    }

    public List<GenericStack> getStacks() {
        return this.stacks;
    }

    public void setStacks(List<GenericStack> stacks) {
        this.stacks.clear();
        this.stacks.addAll(stacks);
    }

    public static void write(RegistryFriendlyByteBuf buffer, RedstoneRequesterConfigurationPacket packet) {
        buffer.writeBlockPos(packet.pos);
        buffer.writeUtf(packet.address);
        buffer.writeBoolean(packet.allowPartial);
        buffer.writeVarInt(packet.stacks.size());
        for (GenericStack stack : packet.stacks) {
            GenericStackSerializer.write((GenericStack)stack, (RegistryFriendlyByteBuf)buffer);
        }
    }

    public static RedstoneRequesterConfigurationPacket read(RegistryFriendlyByteBuf buffer) {
        BlockPos pos = buffer.readBlockPos();
        String address = buffer.readUtf();
        boolean allowPartial = buffer.readBoolean();
        int size = buffer.readVarInt();
        ArrayList<GenericStack> stacks = new ArrayList<GenericStack>(size);
        for (int i = 0; i < size; ++i) {
            stacks.add(GenericStackSerializer.read((RegistryFriendlyByteBuf)buffer));
        }
        return new RedstoneRequesterConfigurationPacket(pos, address, allowPartial, stacks);
    }
}

