/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.jarPackager;

import com.simibubi.create.api.packager.InventoryIdentifier;
import com.simibubi.create.content.logistics.packager.IdentifiedInventory;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.foundation.fluid.FluidHelper;
import java.util.Optional;
import net.createmod.catnip.math.BlockFace;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import ru.zznty.create_factory_abstractions.api.generic.capability.PackageBuilder;
import ru.zznty.create_factory_abstractions.api.generic.capability.PackagerAttachedHandler;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericKeyRegistration;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_abstractions.generic.impl.GenericContentExtender;
import ru.zznty.create_factory_abstractions.generic.support.GenericIdentifiedInventory;
import ru.zznty.create_factory_logistics.FactoryBlocks;
import ru.zznty.create_factory_logistics.logistics.generic.FluidGenericStack;
import ru.zznty.create_factory_logistics.logistics.generic.FluidKey;
import ru.zznty.create_factory_logistics.logistics.jar.JarPackageItem;
import ru.zznty.create_factory_logistics.logistics.jarPackager.JarPackageBuilder;
import ru.zznty.create_factory_logistics.logistics.jarPackager.JarPackagerBlockEntity;

@ApiStatus.Internal
public class JarPackagerAttachedHandler
implements PackagerAttachedHandler {
    private final JarPackagerBlockEntity packagerBE;

    public JarPackagerAttachedHandler(JarPackagerBlockEntity packagerBE) {
        this.packagerBE = packagerBE;
    }

    public int slotCount() {
        return this.packagerBE.drainInventory.hasInventory() ? ((IFluidHandler)this.packagerBE.drainInventory.getInventory()).getTanks() : 0;
    }

    public GenericStack extract(int slot, int amount, boolean simulate) {
        if (!this.packagerBE.drainInventory.hasInventory()) {
            return GenericStack.EMPTY;
        }
        FluidStack existing = ((IFluidHandler)this.packagerBE.drainInventory.getInventory()).getFluidInTank(slot);
        if (existing.isEmpty()) {
            return GenericStack.EMPTY;
        }
        FluidStack extracted = ((IFluidHandler)this.packagerBE.drainInventory.getInventory()).drain(FluidHelper.copyStackWithAmount((FluidStack)existing, (int)amount), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        return extracted.isEmpty() ? GenericStack.EMPTY : FluidGenericStack.wrap(extracted);
    }

    public boolean unwrap(Level level, BlockPos pos, BlockState state, Direction side, @Nullable PackageOrderWithCrafts orderContext, ItemStack box, boolean simulate) {
        if (!(box.getItem() instanceof JarPackageItem)) {
            return false;
        }
        Optional source = FluidUtil.getFluidContained((ItemStack)box);
        Optional destination = FluidUtil.getFluidHandler((Level)level, (BlockPos)pos, (Direction)side);
        if (source.isEmpty() || destination.isEmpty()) {
            return false;
        }
        if (((IFluidHandler)destination.get()).fill((FluidStack)source.get(), IFluidHandler.FluidAction.SIMULATE) != ((FluidStack)source.get()).getAmount()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        return ((IFluidHandler)destination.get()).fill((FluidStack)source.get(), IFluidHandler.FluidAction.EXECUTE) == ((FluidStack)source.get()).getAmount();
    }

    public PackageBuilder newPackage() {
        return new JarPackageBuilder();
    }

    public GenericKeyRegistration supportedKey() {
        return (GenericKeyRegistration)GenericContentExtender.REGISTRATIONS.get(FluidKey.class);
    }

    public Block supportedGauge() {
        return (Block)FactoryBlocks.FACTORY_FLUID_GAUGE.get();
    }

    @Nullable
    public IdentifiedInventory identifiedInventory() {
        IdentifiedInventory inv = new IdentifiedInventory(InventoryIdentifier.get((Level)this.packagerBE.drainInventory.getWorld(), (BlockFace)this.packagerBE.drainInventory.getTarget().getOpposite()), null);
        GenericIdentifiedInventory identifiedInventory = GenericIdentifiedInventory.from((IdentifiedInventory)inv);
        identifiedInventory.setCapability(Capabilities.FluidHandler.BLOCK, (Object)((IFluidHandler)this.packagerBE.drainInventory.getInventory()));
        return inv;
    }
}

