/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.generic;

import com.simibubi.create.foundation.fluid.FluidHelper;
import java.util.List;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import ru.zznty.create_factory_abstractions.api.generic.capability.GenericInventorySummaryProvider;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericKey;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_abstractions.generic.support.GenericInventorySummary;
import ru.zznty.create_factory_logistics.logistics.generic.FluidKey;

final class NetworkFluidHandler
implements IFluidHandler {
    private final List<GenericStack> stacks;

    public NetworkFluidHandler(GenericInventorySummaryProvider summaryProvider) {
        GenericInventorySummary summary = GenericInventorySummary.empty();
        summaryProvider.apply(summary);
        this.stacks = summary.get().stream().filter(s -> s.key() instanceof FluidKey).toList();
    }

    public int getTanks() {
        return this.stacks.size();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return NetworkFluidHandler.asFluid(this.stacks.get(tank));
    }

    public int getTankCapacity(int tank) {
        return Integer.MAX_VALUE - 1 / this.getTanks();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return FluidStack.isSameFluidSameComponents((FluidStack)this.getFluidInTank(tank), (FluidStack)stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (action != IFluidHandler.FluidAction.SIMULATE || resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int amount = 0;
        for (GenericStack stack : this.stacks) {
            FluidStack fluidStack = NetworkFluidHandler.asFluid(stack);
            if (FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)resource)) {
                amount += Math.min(fluidStack.getAmount(), resource.getAmount() - amount);
            }
            if (amount < resource.getAmount()) continue;
            break;
        }
        return FluidHelper.copyStackWithAmount((FluidStack)resource, (int)amount);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack resource = FluidStack.EMPTY;
        for (GenericStack stack : this.stacks) {
            FluidStack fluidStack = NetworkFluidHandler.asFluid(stack);
            if (fluidStack.isEmpty()) continue;
            resource = fluidStack;
            break;
        }
        return this.drain(FluidHelper.copyStackWithAmount((FluidStack)resource, (int)maxDrain), action);
    }

    private static FluidStack asFluid(GenericStack stack) {
        GenericKey genericKey = stack.key();
        if (genericKey instanceof FluidKey) {
            FluidKey fluidKey = (FluidKey)genericKey;
            return FluidHelper.copyStackWithAmount((FluidStack)fluidKey.stack(), (int)stack.amount());
        }
        return FluidStack.EMPTY;
    }
}

