/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.generic;

import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;
import ru.zznty.create_factory_abstractions.api.generic.capability.GenericInventorySummaryProvider;
import ru.zznty.create_factory_abstractions.api.generic.extensibility.GenericKeyProviderExtension;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericCapabilityWrapperProvider;
import ru.zznty.create_factory_logistics.logistics.generic.FluidInventorySummaryProvider;
import ru.zznty.create_factory_logistics.logistics.generic.FluidKey;
import ru.zznty.create_factory_logistics.logistics.generic.NetworkFluidHandler;

public class FluidGenericExtension
implements GenericKeyProviderExtension<FluidKey, FluidStack, Fluid, IFluidHandler> {
    private final GenericCapabilityWrapperProvider<IFluidHandler> provider = new GenericCapabilityWrapperProvider<IFluidHandler>(this){

        public BlockCapability<IFluidHandler, Direction> capability() {
            return Capabilities.FluidHandler.BLOCK;
        }

        public IFluidHandler wrap(GenericInventorySummaryProvider summaryProvider) {
            return new NetworkFluidHandler(summaryProvider);
        }

        public GenericInventorySummaryProvider unwrap(IFluidHandler capability) {
            return new FluidInventorySummaryProvider(capability);
        }
    };

    public FluidKey defaultKey() {
        return this.wrap(FluidStack.EMPTY);
    }

    public FluidKey wrap(FluidStack fluidStack) {
        return new FluidKey((Holder<Fluid>)fluidStack.getFluidHolder(), fluidStack.getComponents());
    }

    public FluidKey wrapGeneric(FluidStack fluidStack) {
        return new FluidKey((Holder<Fluid>)fluidStack.getFluidHolder(), new PatchedDataComponentMap(DataComponentMap.EMPTY));
    }

    public FluidStack unwrap(FluidKey key) {
        return key.stack();
    }

    public String ingredientTypeUid() {
        return "fluid_stack";
    }

    public Optional<ResourceKey<Fluid>> resourceKey(FluidKey key) {
        return Optional.ofNullable(key.fluid().getKey());
    }

    public GenericCapabilityWrapperProvider<IFluidHandler> capabilityWrapperProvider() {
        return this.provider;
    }

    public int compare(FluidKey a, FluidKey b) {
        @Nullable ResourceKey akey = a.fluid().getKey();
        if (akey == null) {
            return -1;
        }
        @Nullable ResourceKey bKey = b.fluid().getKey();
        if (bKey == null) {
            return 1;
        }
        return akey.compareTo(bKey);
    }
}

