/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics;

import java.util.Optional;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class FluidItemStackHandler
extends ItemStackHandler {
    private Fluid fluid = Fluids.EMPTY;

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        if (stack.getItem() instanceof BucketItem) {
            return true;
        }
        return FluidUtil.getFluidHandler((ItemStack)stack).isPresent();
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        ItemStack resultStack = super.insertItem(slot, stack, simulate);
        if (this.getStackInSlot(slot).getItem() instanceof BucketItem) {
            return resultStack;
        }
        this.stacks.set(slot, (Object)new ItemStack((ItemLike)this.fluid.getBucket()));
        return resultStack;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.fluid = FluidItemStackHandler.getFluidFromStack(this.getStackInSlot(slot), this.fluid);
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public static Fluid getFluidFromStack(ItemStack stack, Fluid existingFluid) {
        Item item = stack.getItem();
        if (item instanceof BucketItem) {
            BucketItem be = (BucketItem)item;
            return be.content;
        }
        Optional fluidHandlerOptional = FluidUtil.getFluidHandler((ItemStack)stack);
        if (fluidHandlerOptional.isEmpty()) {
            return Fluids.EMPTY;
        }
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)fluidHandlerOptional.get();
        if (fluidHandler.getTanks() < 1) {
            return Fluids.EMPTY;
        }
        FluidStack fluidInItem = fluidHandler.getFluidInTank(0);
        if (fluidHandler.getTanks() > 1 && (fluidInItem == FluidStack.EMPTY || fluidInItem.getFluid() == existingFluid)) {
            for (int i = 1; i < fluidHandler.getTanks(); ++i) {
                fluidInItem = fluidHandler.getFluidInTank(i);
                if (fluidInItem == FluidStack.EMPTY || fluidInItem.getFluid() == existingFluid) continue;
                return fluidInItem.getFluid();
            }
        }
        return fluidInItem.getFluid();
    }
}

