/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.recipe.charging;

import com.mojang.serialization.MapCodec;
import com.mrh0.createaddition.index.CARecipes;
import com.mrh0.createaddition.recipe.charging.ChargingRecipeParams;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;

public class ChargingRecipe
extends ProcessingRecipe<RecipeWrapper, ChargingRecipeParams> {
    public static final IRecipeTypeInfo TYPE_INFO = new IRecipeTypeInfo(){

        public ResourceLocation getId() {
            return CARecipes.CHARGING.getId();
        }

        public <T extends RecipeSerializer<?>> T getSerializer() {
            return (T)((RecipeSerializer)CARecipes.CHARGING.get());
        }

        public <V extends RecipeInput, R extends Recipe<V>> RecipeType<R> getType() {
            return CARecipes.CHARGING_TYPE.get();
        }
    };
    public int energy;
    public int maxChargeRate;

    public ChargingRecipe(ChargingRecipeParams params) {
        super(TYPE_INFO, (ProcessingRecipeParams)params);
        this.energy = params.getEnergy();
        this.maxChargeRate = params.getMaxChargeRate();
    }

    public boolean matches(@NotNull RecipeWrapper wrapper, @NotNull Level world) {
        if (this.ingredients.get(0) == null) {
            return false;
        }
        return ((Ingredient)this.ingredients.get(0)).test(wrapper.getItem(0));
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 1;
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getMaxChargeRate() {
        return this.maxChargeRate;
    }

    public ItemStack getResultStack() {
        return ((ProcessingOutput)this.getRollableResults().getFirst()).getStack();
    }

    public static class Serializer<R extends ChargingRecipe>
    implements RecipeSerializer<R> {
        private final MapCodec<R> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, R> streamCodec;

        public Serializer(ProcessingRecipe.Factory<ChargingRecipeParams, R> factory) {
            this.codec = ProcessingRecipe.codec(factory, ChargingRecipeParams.CODEC);
            this.streamCodec = ProcessingRecipe.streamCodec(factory, ChargingRecipeParams.STREAM_CODEC);
        }

        public MapCodec<R> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, R> streamCodec() {
            return this.streamCodec;
        }
    }

    public static class Builder<R extends ChargingRecipe>
    extends ProcessingRecipeBuilder<ChargingRecipeParams, R, Builder<R>> {
        public Builder(Factory<R> factory, ResourceLocation recipeId) {
            super(factory, recipeId);
        }

        protected ChargingRecipeParams createParams() {
            return new ChargingRecipeParams();
        }

        public Builder<R> self() {
            return this;
        }

        public Builder<R> enchantedOutput(ItemStack item, ResourceKey<Enchantment> enchantmentKey, HolderLookup.Provider provider) {
            item.enchant(provider.holderOrThrow(enchantmentKey), 1);
            return (Builder)this.output(item);
        }

        public Builder<R> energy(int energy) {
            ((ChargingRecipeParams)this.params).energy = energy;
            return this;
        }

        public Builder<R> maxChargeRate(int maxChargeRate) {
            ((ChargingRecipeParams)this.params).maxChargeRate = maxChargeRate;
            return this;
        }
    }

    @FunctionalInterface
    public static interface Factory<R extends ChargingRecipe>
    extends ProcessingRecipe.Factory<ChargingRecipeParams, R> {
        public R create(ChargingRecipeParams var1);
    }
}

