/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.datagen.RecipeBuilders;

import com.mrh0.createaddition.CreateAddition;
import com.mrh0.createaddition.datagen.RecipeBuilders.CARecipeBuilder;
import com.mrh0.createaddition.recipe.charging.ChargingRecipe;
import com.mrh0.createaddition.recipe.charging.ChargingRecipeParams;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.DataMapHooks;

public class ChargingRecipeBuilder
extends CARecipeBuilder {
    protected Ingredient ingredient = Ingredient.EMPTY;
    protected int energy = 0;
    protected int maxChargeRate = 0;

    public ChargingRecipeBuilder(ItemStack result) {
        super(result);
    }

    public static ChargingRecipeBuilder charging(ItemStack itemStack) {
        return new ChargingRecipeBuilder(itemStack);
    }

    public static ChargingRecipeBuilder charging(ItemLike result, int count) {
        return ChargingRecipeBuilder.charging(new ItemStack(result, count));
    }

    public static ChargingRecipeBuilder charging(ItemLike result) {
        return ChargingRecipeBuilder.charging(new ItemStack(result));
    }

    public static ChargingRecipeBuilder charging(Item result, int count) {
        return ChargingRecipeBuilder.charging(new ItemStack((ItemLike)result, count));
    }

    public static ChargingRecipeBuilder charging(Item result) {
        return ChargingRecipeBuilder.charging(new ItemStack((ItemLike)result));
    }

    public static ChargingRecipeBuilder charging(ItemStack item, ResourceKey<Enchantment> enchantmentKey, HolderLookup.Provider provider) {
        item.enchant(provider.holderOrThrow(enchantmentKey), 1);
        return ChargingRecipeBuilder.charging(item);
    }

    public static ChargingRecipeBuilder deoxidize(Block block) {
        Optional<Block> deoxidizedBlock = Optional.ofNullable(DataMapHooks.getPreviousOxidizedStage((Block)block));
        if (deoxidizedBlock.isEmpty()) {
            CreateAddition.LOGGER.error("Cannot de-oxidize {}", (Object)block);
        }
        return ChargingRecipeBuilder.charging((ItemLike)deoxidizedBlock.get()).require(Ingredient.of((ItemLike[])new ItemLike[]{block})).energy(4000).maxChargeRate(200);
    }

    public static ChargingRecipeBuilder deoxidize(Block block, Block deoxidizedBlock) {
        return ChargingRecipeBuilder.charging((ItemLike)deoxidizedBlock).require(Ingredient.of((ItemLike[])new ItemLike[]{block})).energy(4000).maxChargeRate(200);
    }

    public ChargingRecipeBuilder require(Ingredient ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    public ChargingRecipeBuilder require(ItemLike item) {
        this.require(Ingredient.of((ItemLike[])new ItemLike[]{item}));
        return this;
    }

    public ChargingRecipeBuilder require(ItemStack item) {
        this.require(Ingredient.of((ItemStack[])new ItemStack[]{item}));
        return this;
    }

    public ChargingRecipeBuilder require(ItemLike item, int count) {
        for (int i = 0; i < count; ++i) {
            this.require(Ingredient.of((ItemLike[])new ItemLike[]{item}));
        }
        return this;
    }

    public ChargingRecipeBuilder energy(int energy) {
        this.energy = energy;
        return this;
    }

    public ChargingRecipeBuilder maxChargeRate(int maxChargeRate) {
        this.maxChargeRate = maxChargeRate;
        return this;
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation resourceLocation) {
        ChargingRecipe chargingRecipe = new ChargingRecipe(new ChargingRecipeParams());
        recipeOutput.accept(resourceLocation.withPrefix("charging/"), (Recipe)chargingRecipe, null);
    }

    public void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, BuiltInRegistries.ITEM.getKey((Object)this.result.getItem()).getPath());
    }

    public void save(RecipeOutput recipeOutput, String id) {
        this.save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"createaddition", (String)id));
    }
}

