/*
 * Decompiled with CFR 0.152.
 */
package littlechasiu.ctm;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JvmStreamsKt;
import littlechasiu.ctm.Server;
import littlechasiu.ctm.TrackWatcher;
import littlechasiu.ctm.model.BlockStatus;
import littlechasiu.ctm.model.Config;
import littlechasiu.ctm.model.Network;
import littlechasiu.ctm.model.SignalStatus;
import littlechasiu.ctm.model.TrainStatus;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="createtrackmap")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u00107\u001a\u000208H\u0002J\b\u00109\u001a\u000208H\u0002J\u000e\u0010:\u001a\u0002082\u0006\u0010;\u001a\u00020<J\u000e\u0010=\u001a\u0002082\u0006\u0010;\u001a\u00020>J\u000e\u0010?\u001a\u0002082\u0006\u0010;\u001a\u00020@R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0003R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010(\u001a\b\u0012\u0004\u0012\u0002H*0)\"\u0004\b\u0000\u0010**\b\u0012\u0004\u0012\u0002H*0+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0017\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00170)\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0017\u00101\u001a\b\u0012\u0004\u0012\u00020\u001b0)\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00100R\u0017\u00103\u001a\b\u0012\u0004\u0012\u00020\u001f0)\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00100R\u0017\u00105\u001a\b\u0012\u0004\u0012\u00020#0)\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00100\u00a8\u0006A"}, d2={"Llittlechasiu/ctm/TrackMap;", "", "<init>", "()V", "MODID", "", "configFileName", "JSON", "Lkotlinx/serialization/json/Json;", "getJSON$annotations", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "getLOGGER", "()Lorg/apache/logging/log4j/Logger;", "config", "Llittlechasiu/ctm/model/Config;", "watcher", "Llittlechasiu/ctm/TrackWatcher;", "getWatcher", "()Llittlechasiu/ctm/TrackWatcher;", "server", "Llittlechasiu/ctm/Server;", "network", "Llittlechasiu/ctm/model/Network;", "getNetwork", "()Llittlechasiu/ctm/model/Network;", "signals", "Llittlechasiu/ctm/model/SignalStatus;", "getSignals", "()Llittlechasiu/ctm/model/SignalStatus;", "blocks", "Llittlechasiu/ctm/model/BlockStatus;", "getBlocks", "()Llittlechasiu/ctm/model/BlockStatus;", "trains", "Llittlechasiu/ctm/model/TrainStatus;", "getTrains", "()Llittlechasiu/ctm/model/TrainStatus;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "flow", "Lkotlinx/coroutines/flow/SharedFlow;", "T", "Lkotlinx/coroutines/channels/Channel;", "getFlow", "(Lkotlinx/coroutines/channels/Channel;)Lkotlinx/coroutines/flow/SharedFlow;", "networkFlow", "getNetworkFlow", "()Lkotlinx/coroutines/flow/SharedFlow;", "signalFlow", "getSignalFlow", "blockFlow", "getBlockFlow", "trainFlow", "getTrainFlow", "loadConfig", "", "reload", "registerCommands", "event", "Lnet/neoforged/neoforge/event/RegisterCommandsEvent;", "serverStarted", "Lnet/neoforged/neoforge/event/server/ServerStartedEvent;", "serverStopping", "Lnet/neoforged/neoforge/event/server/ServerStoppingEvent;", "createtrackmap"})
@SourceDebugExtension(value={"SMAP\nTrackMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrackMap.kt\nlittlechasiu/ctm/TrackMap\n+ 2 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n+ 3 Forge.kt\nthedarkcolour/kotlinforforge/neoforge/forge/ForgeKt\n*L\n1#1,127:1\n80#2:128\n42#2:129\n17#3:130\n17#3:131\n17#3:132\n*S KotlinDebug\n*F\n+ 1 TrackMap.kt\nlittlechasiu/ctm/TrackMap\n*L\n66#1:128\n70#1:129\n122#1:130\n123#1:131\n124#1:132\n*E\n"})
public final class TrackMap {
    @NotNull
    public static final TrackMap INSTANCE = new TrackMap();
    @NotNull
    public static final String MODID = "createtrackmap";
    @NotNull
    private static final String configFileName = "create-track-map.json";
    @NotNull
    private static final Json JSON = JsonKt.Json$default(null, TrackMap::JSON$lambda$0, (int)1, null);
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static Config config;
    @NotNull
    private static final TrackWatcher watcher;
    @NotNull
    private static final Server server;
    @NotNull
    private static final CoroutineScope scope;
    @NotNull
    private static final SharedFlow<Network> networkFlow;
    @NotNull
    private static final SharedFlow<SignalStatus> signalFlow;
    @NotNull
    private static final SharedFlow<BlockStatus> blockFlow;
    @NotNull
    private static final SharedFlow<TrainStatus> trainFlow;

    private TrackMap() {
    }

    private static /* synthetic */ void getJSON$annotations() {
    }

    @NotNull
    public final Logger getLOGGER() {
        return LOGGER;
    }

    @NotNull
    public final TrackWatcher getWatcher() {
        return watcher;
    }

    @NotNull
    public final Network getNetwork() {
        return watcher.getNetwork();
    }

    @NotNull
    public final SignalStatus getSignals() {
        return watcher.getSignalStatus();
    }

    @NotNull
    public final BlockStatus getBlocks() {
        return watcher.getBlockStatus();
    }

    @NotNull
    public final TrainStatus getTrains() {
        return watcher.getTrainStatus();
    }

    private final <T> SharedFlow<T> getFlow(Channel<T> $this$flow) {
        return FlowKt.shareIn$default((Flow)FlowKt.distinctUntilChanged((Flow)FlowKt.consumeAsFlow((ReceiveChannel)((ReceiveChannel)$this$flow))), (CoroutineScope)scope, (SharingStarted)SharingStarted.Companion.getEagerly(), (int)0, (int)4, null);
    }

    @NotNull
    public final SharedFlow<Network> getNetworkFlow() {
        return networkFlow;
    }

    @NotNull
    public final SharedFlow<SignalStatus> getSignalFlow() {
        return signalFlow;
    }

    @NotNull
    public final SharedFlow<BlockStatus> getBlockFlow() {
        return blockFlow;
    }

    @NotNull
    public final SharedFlow<TrainStatus> getTrainFlow() {
        return trainFlow;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadConfig() {
        try {
            String[] stringArray = new String[]{configFileName};
            Path configFile = Path.of(((Object)FMLPaths.CONFIGDIR.get()).toString(), stringArray);
            if (Files.exists(configFile, new LinkOption[0])) {
                stringArray = JSON;
                InputStream inputStream = Files.newInputStream(configFile, new OpenOption[0]);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                InputStream stream$iv2 = inputStream;
                boolean $i$f$decodeFromStream = false;
                $this$decodeFromStream$iv.getSerializersModule();
                config = (Config)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)Config.Companion.serializer()), (InputStream)stream$iv2);
            } else {
                void stream$iv;
                void value$iv;
                void $this$encodeToStream$iv;
                LOGGER.warn("Create Track Map config does not exist, writing defaults to create-track-map.json");
                config = new Config(false, 0.0, 0, null, null, null, null, 127, null);
                $this$decodeFromStream$iv = JSON;
                Config stream$iv2 = config;
                OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE};
                OutputStream outputStream = Files.newOutputStream(configFile, openOptionArray);
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
                OutputStream $i$f$decodeFromStream = outputStream;
                boolean $i$f$encodeToStream = false;
                $this$encodeToStream$iv.getSerializersModule();
                JvmStreamsKt.encodeToStream((Json)$this$encodeToStream$iv, (SerializationStrategy)((SerializationStrategy)Config.Companion.serializer()), (Object)value$iv, (OutputStream)stream$iv);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error loading Create Track Map config, using defaults");
            e.printStackTrace();
            config = new Config(false, 0.0, 0, null, null, null, null, 127, null);
        }
        watcher.setEnable(config.getEnable());
        server.setEnable(config.getEnable());
        watcher.setWatchInterval-LRDsOJo(DurationKt.toDuration((double)config.getWatchIntervalSeconds(), (DurationUnit)DurationUnit.SECONDS));
        server.setPort(config.getServerPort());
        server.setMapStyle(config.getMapStyle());
        server.setMapView(config.getMapView());
        server.setDimensions(config.getDimensions());
        server.setLayers(config.getLayers());
    }

    private final void reload() {
        watcher.stop();
        server.stop();
        this.loadConfig();
        watcher.start();
        server.start();
    }

    public final void registerCommands(@NotNull RegisterCommandsEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"ctm").then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(TrackMap::registerCommands$lambda$1)).executes(TrackMap::registerCommands$lambda$2)));
    }

    public final void serverStarted(@NotNull ServerStartedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        watcher.start();
        server.start();
    }

    public final void serverStopping(@NotNull ServerStoppingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        watcher.stop();
        server.stop();
    }

    private static final Unit JSON$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setLenient(true);
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setPrettyPrint(true);
        $this$Json.setPrettyPrintIndent("  ");
        return Unit.INSTANCE;
    }

    private static final boolean registerCommands$lambda$1(CommandSourceStack src) {
        return src.hasPermission(4);
    }

    private static final int registerCommands$lambda$2(CommandContext commandContext) {
        INSTANCE.reload();
        return 1;
    }

    static {
        Logger logger = LogManager.getLogger((String)MODID);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        config = new Config(false, 0.0, 0, null, null, null, null, 127, null);
        watcher = new TrackWatcher();
        server = new Server();
        scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        networkFlow = INSTANCE.getFlow(watcher.getNetworkChannel());
        signalFlow = INSTANCE.getFlow(watcher.getSignalChannel());
        blockFlow = INSTANCE.getFlow(watcher.getBlockChannel());
        trainFlow = INSTANCE.getFlow(watcher.getTrainChannel());
        INSTANCE.loadConfig();
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(INSTANCE::registerCommands);
        $i$f$getFORGE_BUS = false;
        IEventBus iEventBus2 = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus2, (String)"EVENT_BUS");
        iEventBus2.addListener(INSTANCE::serverStarted);
        $i$f$getFORGE_BUS = false;
        IEventBus iEventBus3 = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus3, (String)"EVENT_BUS");
        iEventBus3.addListener(INSTANCE::serverStopping);
    }
}

