/*
 * Decompiled with CFR 0.152.
 */
package littlechasiu.ctm;

import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0086\u0002\u001a\u0015\u0010\u0003\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0086\u0002\u001a\r\u0010\u0006\u001a\u00020\u0001*\u00020\u0001H\u0086\u0002\u001a\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b*\b\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\t\u001a\u00020\u0005\u001a\u0012\u0010\r\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0012\u0010\u0011\u001a\u00020\u0001*\u00020\u00102\u0006\u0010\t\u001a\u00020\u0005\u001a\u0012\u0010\u0012\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\"\u0015\u0010\n\u001a\u00020\u0005*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"plus", "Lnet/minecraft/world/phys/Vec3;", "other", "times", "scale", "", "unaryMinus", "multiLerp", "", "position", "angle", "getAngle", "(Lnet/minecraft/world/phys/Vec3;)D", "locationOn", "Lcom/simibubi/create/content/trains/signal/TrackEdgePoint;", "edge", "Lcom/simibubi/create/content/trains/graph/TrackEdge;", "directionAt", "angleOn", "createtrackmap"})
public final class MathKt {
    @NotNull
    public static final Vec3 plus(@NotNull Vec3 $this$plus, @NotNull Vec3 other) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Vec3($this$plus.x + other.x, $this$plus.y + other.y, $this$plus.z + other.z);
    }

    @NotNull
    public static final Vec3 times(@NotNull Vec3 $this$times, double scale) {
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        return new Vec3($this$times.x * scale, $this$times.y * scale, $this$times.z * scale);
    }

    @NotNull
    public static final Vec3 unaryMinus(@NotNull Vec3 $this$unaryMinus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryMinus, (String)"<this>");
        return MathKt.times($this$unaryMinus, -1.0);
    }

    @NotNull
    public static final List<Vec3> multiLerp(@NotNull List<? extends Vec3> $this$multiLerp, double position) {
        Intrinsics.checkNotNullParameter($this$multiLerp, (String)"<this>");
        return CollectionsKt.toList((Iterable)CollectionsKt.windowed$default((Iterable)$this$multiLerp, (int)2, (int)0, (boolean)false, arg_0 -> MathKt.multiLerp$lambda$0(position, arg_0), (int)6, null));
    }

    public static final double getAngle(@NotNull Vec3 $this$angle) {
        Intrinsics.checkNotNullParameter((Object)$this$angle, (String)"<this>");
        return kotlin.math.MathKt.roundToInt((double)(Math.atan2($this$angle.x, -$this$angle.z) * 57.29577951308232));
    }

    @NotNull
    public static final Vec3 locationOn(@NotNull TrackEdgePoint $this$locationOn, @NotNull TrackEdge edge) {
        Intrinsics.checkNotNullParameter((Object)$this$locationOn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        double basePos = $this$locationOn.isPrimary(edge.node1) ? edge.getLength() - $this$locationOn.position : $this$locationOn.position;
        Vec3 vec3 = edge.getPosition(null, basePos / edge.getLength());
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getPosition(...)");
        return vec3;
    }

    @NotNull
    public static final Vec3 directionAt(@NotNull TrackEdge $this$directionAt, double position) {
        Intrinsics.checkNotNullParameter((Object)$this$directionAt, (String)"<this>");
        double step = 0.05 / $this$directionAt.getLength();
        double t = position / $this$directionAt.getLength();
        Vec3 ahead = $this$directionAt.getPosition(null, RangesKt.coerceAtMost((double)(t + step), (double)1.0));
        Vec3 behind = $this$directionAt.getPosition(null, RangesKt.coerceAtLeast((double)(t - step), (double)0.0));
        Vec3 vec3 = ahead.subtract(behind).normalize();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"normalize(...)");
        return vec3;
    }

    public static final double angleOn(@NotNull TrackEdgePoint $this$angleOn, @NotNull TrackEdge edge) {
        Intrinsics.checkNotNullParameter((Object)$this$angleOn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        double basePos = $this$angleOn.isPrimary(edge.node1) ? edge.getLength() - $this$angleOn.position : $this$angleOn.position;
        Vec3 vec = MathKt.directionAt(edge, basePos);
        return $this$angleOn.isPrimary(edge.node1) ? MathKt.getAngle(vec) + (double)180 : MathKt.getAngle(vec);
    }

    private static final Vec3 multiLerp$lambda$0(double $position, List lst) {
        Intrinsics.checkNotNullParameter((Object)lst, (String)"lst");
        Vec3 a = (Vec3)lst.get(0);
        Vec3 b = (Vec3)lst.get(1);
        return a.lerp(b, $position);
    }
}

