/*
 * Decompiled with CFR 0.152.
 */
package littlechasiu.ctm;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import littlechasiu.ctm.ExtensionsKt;
import littlechasiu.ctm.Track;
import littlechasiu.ctm.model.Edge;
import littlechasiu.ctm.model.Point;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Llittlechasiu/ctm/Line;", "Llittlechasiu/ctm/Track;", "dimension", "", "start", "Lnet/minecraft/world/phys/Vec3;", "end", "<init>", "(Ljava/lang/String;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;)V", "getDimension", "()Ljava/lang/String;", "getStart", "()Lnet/minecraft/world/phys/Vec3;", "getEnd", "sendable", "Llittlechasiu/ctm/model/Edge;", "getSendable", "()Llittlechasiu/ctm/model/Edge;", "divideAt", "Lkotlin/Pair;", "position", "", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "createtrackmap"})
public final class Line
implements Track {
    @NotNull
    private final String dimension;
    @NotNull
    private final Vec3 start;
    @NotNull
    private final Vec3 end;

    public Line(@NotNull String dimension, @NotNull Vec3 start2, @NotNull Vec3 end) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this.dimension = dimension;
        this.start = start2;
        this.end = end;
    }

    @NotNull
    public final String getDimension() {
        return this.dimension;
    }

    @NotNull
    public final Vec3 getStart() {
        return this.start;
    }

    @NotNull
    public final Vec3 getEnd() {
        return this.end;
    }

    @Override
    @NotNull
    public Edge getSendable() {
        Object[] objectArray = new Point[]{ExtensionsKt.getSendable(this.start), ExtensionsKt.getSendable(this.end)};
        return new Edge(this.dimension, CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    @NotNull
    public Pair<Track, Track> divideAt(double position) {
        Vec3 point = this.start.lerp(this.end, position);
        Intrinsics.checkNotNull((Object)point);
        return new Pair((Object)new Line(this.dimension, this.start, point), (Object)new Line(this.dimension, point, this.end));
    }

    @NotNull
    public final String component1() {
        return this.dimension;
    }

    @NotNull
    public final Vec3 component2() {
        return this.start;
    }

    @NotNull
    public final Vec3 component3() {
        return this.end;
    }

    @NotNull
    public final Line copy(@NotNull String dimension, @NotNull Vec3 start2, @NotNull Vec3 end) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return new Line(dimension, start2, end);
    }

    public static /* synthetic */ Line copy$default(Line line, String string, Vec3 vec3, Vec3 vec32, int n, Object object) {
        if ((n & 1) != 0) {
            string = line.dimension;
        }
        if ((n & 2) != 0) {
            vec3 = line.start;
        }
        if ((n & 4) != 0) {
            vec32 = line.end;
        }
        return line.copy(string, vec3, vec32);
    }

    @NotNull
    public String toString() {
        return "Line(dimension=" + this.dimension + ", start=" + this.start + ", end=" + this.end + ")";
    }

    public int hashCode() {
        int result = this.dimension.hashCode();
        result = result * 31 + this.start.hashCode();
        result = result * 31 + this.end.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Line)) {
            return false;
        }
        Line line = (Line)other;
        if (!Intrinsics.areEqual((Object)this.dimension, (Object)line.dimension)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.start, (Object)line.start)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.end, (Object)line.end);
    }
}

