/*
 * Decompiled with CFR 0.152.
 */
package littlechasiu.ctm;

import com.simibubi.create.content.trains.track.BezierConnection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import littlechasiu.ctm.ExtensionsKt;
import littlechasiu.ctm.MathKt;
import littlechasiu.ctm.Track;
import littlechasiu.ctm.model.Edge;
import littlechasiu.ctm.model.Point;
import net.createmod.catnip.data.Couple;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 +2\u00020\u0001:\u0001+B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J;\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006,"}, d2={"Llittlechasiu/ctm/BezierCurve;", "Llittlechasiu/ctm/Track;", "dimension", "", "start", "Lnet/minecraft/world/phys/Vec3;", "controlPoint1", "controlPoint2", "end", "<init>", "(Ljava/lang/String;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;)V", "getDimension", "()Ljava/lang/String;", "getStart", "()Lnet/minecraft/world/phys/Vec3;", "getControlPoint1", "getControlPoint2", "getEnd", "sendable", "Llittlechasiu/ctm/model/Edge;", "getSendable", "()Llittlechasiu/ctm/model/Edge;", "points", "", "getPoints", "()Ljava/util/List;", "divideAt", "Lkotlin/Pair;", "position", "", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "createtrackmap"})
public final class BezierCurve
implements Track {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String dimension;
    @NotNull
    private final Vec3 start;
    @NotNull
    private final Vec3 controlPoint1;
    @NotNull
    private final Vec3 controlPoint2;
    @NotNull
    private final Vec3 end;

    public BezierCurve(@NotNull String dimension, @NotNull Vec3 start2, @NotNull Vec3 controlPoint1, @NotNull Vec3 controlPoint2, @NotNull Vec3 end) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)controlPoint1, (String)"controlPoint1");
        Intrinsics.checkNotNullParameter((Object)controlPoint2, (String)"controlPoint2");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this.dimension = dimension;
        this.start = start2;
        this.controlPoint1 = controlPoint1;
        this.controlPoint2 = controlPoint2;
        this.end = end;
    }

    @NotNull
    public final String getDimension() {
        return this.dimension;
    }

    @NotNull
    public final Vec3 getStart() {
        return this.start;
    }

    @NotNull
    public final Vec3 getControlPoint1() {
        return this.controlPoint1;
    }

    @NotNull
    public final Vec3 getControlPoint2() {
        return this.controlPoint2;
    }

    @NotNull
    public final Vec3 getEnd() {
        return this.end;
    }

    @Override
    @NotNull
    public Edge getSendable() {
        Object[] objectArray = new Point[]{ExtensionsKt.getSendable(this.start), ExtensionsKt.getSendable(this.controlPoint1), ExtensionsKt.getSendable(this.controlPoint2), ExtensionsKt.getSendable(this.end)};
        return new Edge(this.dimension, CollectionsKt.listOf((Object[])objectArray));
    }

    private final List<Vec3> getPoints() {
        Object[] objectArray = new Vec3[]{this.start, this.controlPoint1, this.controlPoint2, this.end};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public Pair<BezierCurve, BezierCurve> divideAt(double position) {
        List<Vec3> points1 = MathKt.multiLerp(this.getPoints(), position);
        List<Vec3> points2 = MathKt.multiLerp(points1, position);
        List<Vec3> points3 = MathKt.multiLerp(points2, position);
        Vec3 cp11 = points1.get(0);
        Vec3 cp12 = points2.get(0);
        Vec3 midpoint = points3.get(0);
        Vec3 cp21 = points2.get(1);
        Vec3 cp22 = points1.get(2);
        return new Pair((Object)new BezierCurve(this.dimension, this.start, cp11, cp12, midpoint), (Object)new BezierCurve(this.dimension, midpoint, cp21, cp22, this.end));
    }

    @NotNull
    public final String component1() {
        return this.dimension;
    }

    @NotNull
    public final Vec3 component2() {
        return this.start;
    }

    @NotNull
    public final Vec3 component3() {
        return this.controlPoint1;
    }

    @NotNull
    public final Vec3 component4() {
        return this.controlPoint2;
    }

    @NotNull
    public final Vec3 component5() {
        return this.end;
    }

    @NotNull
    public final BezierCurve copy(@NotNull String dimension, @NotNull Vec3 start2, @NotNull Vec3 controlPoint1, @NotNull Vec3 controlPoint2, @NotNull Vec3 end) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)controlPoint1, (String)"controlPoint1");
        Intrinsics.checkNotNullParameter((Object)controlPoint2, (String)"controlPoint2");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return new BezierCurve(dimension, start2, controlPoint1, controlPoint2, end);
    }

    public static /* synthetic */ BezierCurve copy$default(BezierCurve bezierCurve, String string, Vec3 vec3, Vec3 vec32, Vec3 vec33, Vec3 vec34, int n, Object object) {
        if ((n & 1) != 0) {
            string = bezierCurve.dimension;
        }
        if ((n & 2) != 0) {
            vec3 = bezierCurve.start;
        }
        if ((n & 4) != 0) {
            vec32 = bezierCurve.controlPoint1;
        }
        if ((n & 8) != 0) {
            vec33 = bezierCurve.controlPoint2;
        }
        if ((n & 0x10) != 0) {
            vec34 = bezierCurve.end;
        }
        return bezierCurve.copy(string, vec3, vec32, vec33, vec34);
    }

    @NotNull
    public String toString() {
        return "BezierCurve(dimension=" + this.dimension + ", start=" + this.start + ", controlPoint1=" + this.controlPoint1 + ", controlPoint2=" + this.controlPoint2 + ", end=" + this.end + ")";
    }

    public int hashCode() {
        int result = this.dimension.hashCode();
        result = result * 31 + this.start.hashCode();
        result = result * 31 + this.controlPoint1.hashCode();
        result = result * 31 + this.controlPoint2.hashCode();
        result = result * 31 + this.end.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BezierCurve)) {
            return false;
        }
        BezierCurve bezierCurve = (BezierCurve)other;
        if (!Intrinsics.areEqual((Object)this.dimension, (Object)bezierCurve.dimension)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.start, (Object)bezierCurve.start)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.controlPoint1, (Object)bezierCurve.controlPoint1)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.controlPoint2, (Object)bezierCurve.controlPoint2)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.end, (Object)bezierCurve.end);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Llittlechasiu/ctm/BezierCurve$Companion;", "", "<init>", "()V", "from", "Llittlechasiu/ctm/BezierCurve;", "conn", "Lcom/simibubi/create/content/trains/track/BezierConnection;", "dim", "", "createtrackmap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BezierCurve from(@NotNull BezierConnection conn, @NotNull String dim) {
            Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
            Intrinsics.checkNotNullParameter((Object)dim, (String)"dim");
            Couple couple = conn.starts;
            Intrinsics.checkNotNull((Object)couple);
            Vec3 start2 = (Vec3)ExtensionsKt.component1(couple);
            Vec3 end = (Vec3)ExtensionsKt.component2(couple);
            Couple couple2 = conn.axes;
            Intrinsics.checkNotNull((Object)couple2);
            Vec3 startAxis = (Vec3)ExtensionsKt.component1(couple2);
            Vec3 endAxis = (Vec3)ExtensionsKt.component2(couple2);
            Intrinsics.checkNotNull((Object)start2);
            Intrinsics.checkNotNull((Object)startAxis);
            Vec3 vec3 = MathKt.plus(start2, MathKt.times(startAxis, conn.getHandleLength()));
            Intrinsics.checkNotNull((Object)end);
            Intrinsics.checkNotNull((Object)endAxis);
            return new BezierCurve(dim, start2, vec3, MathKt.plus(end, MathKt.times(endAxis, conn.getHandleLength())), end);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

